% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/struct_equiv.R
\name{transformGraphBy}
\alias{transformGraphBy}
\alias{transformGraphBy.dgCMatrix}
\alias{transformGraphBy.diffnet}
\title{Apply a function to a graph considering non-diagonal structural zeros}
\usage{
transformGraphBy(graph, INDICES, fun = function(g, ...) g, ...)

\method{transformGraphBy}{diffnet}(graph, INDICES, fun = function(g, ...) g,
  ...)

\method{transformGraphBy}{dgCMatrix}(graph, INDICES, fun = function(g, ...) g,
  ...)
}
\arguments{
\item{graph}{A graph}

\item{INDICES}{A vector of length \eqn{n}.}

\item{fun}{A function to apply}

\item{...}{Further arguments passed to \code{fun}}
}
\description{
When there are structural zeros given by groups, this function applies
a particular transformation function of a graph by groups returning a
square matrix of the same size of the original one with structural zeros
and the function applied by \code{INDICES}.
}
\details{
The transformation function \code{fun} must return a square matrix
of size \eqn{m\times m}{m*m}, where \eqn{m} is the size of the subgroup
given by \code{INDICES}. See examples below
}
\examples{
# Rewiring a graph by

}

