% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjmat.r
\name{toa_diff}
\alias{toa_diff}
\title{Difference in Time of Adoption (TOA) between individuals}
\usage{
toa_diff(obj, t0 = NULL, labels = NULL)
}
\arguments{
\item{obj}{Either an integer vector of length \eqn{n} containing time of adoption
of the innovation, a matrix of size \eqn{n \times Q} (for multiple \eqn{Q} behaviors), or
a \code{\link{diffnet}} object (both for single or multiple behaviors).}

\item{t0}{Integer scalar. Sets the lower bound of the time window (e.g. 1955).}

\item{labels}{Character vector of length \eqn{n}. Labels (ids) of the vertices.}
}
\value{
An \eqn{n \times n}{n * n} anti-symmetric matrix (or a list of them,
for \eqn{Q}{Q} behaviors) indicating the difference in times of
adoption between each pair of nodes.
}
\description{
Creates an \eqn{n \times n}{n * n} matrix, or for \eqn{Q}{Q} behaviors, a list
of length \eqn{Q}{Q} containing \eqn{n \times n}{n * n} matrices, that indicates
the difference in adoption times between each pair of nodes.
}
\details{
Each cell \eqn{ij}{ij} of the resulting matrix is calculated as \eqn{toa_j - toa_i}{%
toa(j) - toa(i)}, so that whenever its positive it means that the j-th individual (alter)
adopted the innovation sooner.
}
\examples{
# For a single behavior -----------------------------------------------------

# Generating a random vector of time
set.seed(123)
times <- sample(2000:2005, 10, TRUE)

# Computing the TOA differences
toa_diff(times)

# For Q=2 behaviors ---------------------------------------------------------

# Generating a matrix time

times_1 <- c(2001L, 2004L, 2003L, 2008L)
times_2 <- c(2001L, 2005L, 2006L, 2008L)
times <- matrix(c(times_1, times_2), nrow = 4, ncol = 2)

# Computing the TOA differences
toa_diff(times)

# Or, from a diffnet object

graph <- lapply(2001:2008, function(x) rgraph_er(4))
diffnet <- new_diffnet(graph, times)

# Computing the TOA differences
toa_diff(diffnet)


}
\author{
George G. Vega Yon, Thomas W. Valente, and Aníbal Olivera M.
}
\keyword{manip}
