% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netdistance.R
\name{netdistance}
\alias{netdistance}
\title{Calculate distance matrix for an adjacency matrix}
\usage{
netdistance(x)
}
\arguments{
\item{x}{Either a netmeta object or an adjacency matrix.}
}
\description{
Calculate distance matrix for an adjacency matrix based on distance
algorithm by Müller et al. (1987).
}
\examples{
data(smokingcessation)

p1 <- pairwise(list(treat1, treat2, treat3),
  event = list(event1, event2, event3), n = list(n1, n2, n3),
  data = smokingcessation, sm = "OR")
net1 <- netmeta(p1, common = FALSE)

netdistance(net1)

\dontrun{
data(Senn2013)

net1 <- netmeta(TE, seTE, treat1, treat2, studlab,
  data = Senn2013, sm = "MD")

netdistance(net1)
netdistance(net1$A.matrix)
}

}
\references{
Müller WR, Szymanski K, Knop JV, and Trinajstic N (1987):
An algorithm for construction of the molecular distance matrix.
\emph{Journal of Computational Chemistry},
\bold{8}, 170--73
}
\seealso{
\code{\link{netmeta}}, \code{\link{netconnection}}
}
\author{
Gerta Rücker \email{gerta.ruecker@uniklinik-freiburg.de}
}
