% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netmeta.R
\name{netmeta}
\alias{netmeta}
\title{Network meta-analysis using graph-theoretical method}
\usage{
netmeta(
  TE,
  seTE,
  treat1,
  treat2,
  studlab,
  data = NULL,
  subset = NULL,
  correlated,
  sm,
  level = gs("level"),
  level.ma = gs("level.ma"),
  common = gs("common"),
  random = gs("random") | !is.null(tau.preset),
  prediction = gs("prediction"),
  level.predict = gs("level.predict"),
  reference.group,
  baseline.reference = gs("baseline.reference"),
  small.values = gs("small.values"),
  all.treatments = gs("all.treatments"),
  seq = gs("seq"),
  method.tau = gs("method.tau.netmeta"),
  tau.preset = NULL,
  tol.multiarm = gs("tol.multiarm"),
  tol.multiarm.se = gs("tol.multiarm.se"),
  details.chkmultiarm = gs("details.chkmultiarm"),
  sep.trts = gs("sep.trts"),
  nchar.trts = gs("nchar.trts"),
  nchar.studlab = gs("nchar.studlab"),
  func.inverse = invmat,
  n1 = NULL,
  n2 = NULL,
  event1 = NULL,
  event2 = NULL,
  incr = NULL,
  mean1 = NULL,
  mean2 = NULL,
  sd1 = NULL,
  sd2 = NULL,
  time1 = NULL,
  time2 = NULL,
  overall.hetstat = gs("overall.hetstat"),
  backtransf = gs("backtransf"),
  title = gs("title"),
  keepdata = gs("keepdata"),
  keeprma = gs("keeprma"),
  control = NULL,
  warn = gs("warn"),
  warn.deprecated = gs("warn.deprecated"),
  nchar = nchar.trts,
  ...
)
}
\arguments{
\item{TE}{Estimate of treatment effect, i.e. difference between
first and second treatment (e.g. log odds ratio, mean difference,
or log hazard ratio). Or an R object created with
\code{\link[meta]{pairwise}}.}

\item{seTE}{Standard error of treatment estimate.}

\item{treat1}{Label/Number for first treatment.}

\item{treat2}{Label/Number for second treatment.}

\item{studlab}{An optional - but important! - vector with study
labels (see Details).}

\item{data}{An optional data frame containing the study
information.}

\item{subset}{An optional vector specifying a subset of studies to
be used.}

\item{correlated}{An optional logical vector specifying whether
treatment arms of a multi-arm study are correlated (see Details).}

\item{sm}{A character string indicating underlying summary measure,
e.g., \code{"RD"}, \code{"RR"}, \code{"OR"}, \code{"ASD"},
\code{"HR"}, \code{"MD"}, \code{"SMD"}, or \code{"ROM"}.}

\item{level}{The level used to calculate confidence intervals for
individual comparisons.}

\item{level.ma}{The level used to calculate confidence intervals
for network estimates.}

\item{common}{A logical indicating whether a common effects network
meta-analysis should be conducted.}

\item{random}{A logical indicating whether a random effects network
meta-analysis should be conducted.}

\item{prediction}{A logical indicating whether prediction intervals
should be printed.}

\item{level.predict}{The level used to calculate prediction
intervals for a new study.}

\item{reference.group}{Reference treatment (first treatment is used
if argument is missing).}

\item{baseline.reference}{A logical indicating whether results
should be expressed as comparisons of other treatments versus the
reference treatment (default) or vice versa. This argument is
only considered if \code{reference.group} has been specified.}

\item{small.values}{A character string specifying whether small
treatment effects indicate a beneficial (\code{"desirable"}) or
harmful (\code{"undesirable"}) effect (passed on to
\code{\link{netrank}}, can be abbreviated.}

\item{all.treatments}{A logical or \code{"NULL"}. If \code{TRUE},
matrices with all treatment effects, and confidence limits will
be printed.}

\item{seq}{A character or numerical vector specifying the sequence
of treatments in printouts.}

\item{method.tau}{A character string indicating which method is
used to estimate the between-study variance \eqn{\tau^2} and its
square root \eqn{\tau}. Either \code{"DL"}, \code{"REML"}, or
\code{"ML"}, can be abbreviated.}

\item{tau.preset}{An optional value for manually setting the
square-root of the between-study variance \eqn{\tau^2}.}

\item{tol.multiarm}{A numeric for the tolerance for consistency of
treatment estimates in multi-arm studies which are consistent by
design.}

\item{tol.multiarm.se}{A numeric for the tolerance for consistency
of standard errors in multi-arm studies which are consistent by
design. This check is not conducted if the argument is
\code{NULL}.}

\item{details.chkmultiarm}{A logical indicating whether treatment
estimates and / or variances of multi-arm studies with
inconsistent results or negative multi-arm variances should be
printed.}

\item{sep.trts}{A character used in comparison names as separator
between treatment labels.}

\item{nchar.trts}{A numeric defining the minimum number of
characters used to create unique treatment names (see Details).}

\item{nchar.studlab}{A numeric defining the minimum number of
characters used to create unique study labels.}

\item{func.inverse}{R function used to calculate the pseudoinverse
of the Laplacian matrix L (see Details).}

\item{n1}{Number of observations in first treatment group.}

\item{n2}{Number of observations in second treatment group.}

\item{event1}{Number of events in first treatment group.}

\item{event2}{Number of events in second treatment group.}

\item{incr}{Numerical value added to cell frequencies (for details,
see \code{\link[meta]{pairwise}}).}

\item{mean1}{Mean in first treatment group.}

\item{mean2}{Mean in second treatment group.}

\item{sd1}{Standard deviation in first treatment group.}

\item{sd2}{Standard deviation in second treatment group.}

\item{time1}{Person time at risk in first treatment group.}

\item{time2}{Person time at risk in second treatment group.}

\item{overall.hetstat}{A logical indicating whether to print heterogeneity
measures.}

\item{backtransf}{A logical indicating whether results should be
back transformed in printouts and forest plots. If
\code{backtransf = TRUE}, results for \code{sm = "OR"} are
presented as odds ratios rather than log odds ratios, for
example.}

\item{title}{Title of meta-analysis / systematic review.}

\item{keepdata}{A logical indicating whether original data(set)
should be kept in netmeta object.}

\item{keeprma}{A logical indicating whether \code{\link[metafor]{rma.mv}}
object should be stored.}

\item{control}{An optional list to control the iterative process to
estimate the between-study variance \eqn{\tau^2}. This argument
is passed on to \code{\link[metafor]{rma.mv}}.}

\item{warn}{A logical indicating whether warnings should be printed
(e.g., if studies are excluded from meta-analysis due to zero
standard errors).}

\item{warn.deprecated}{A logical indicating whether warnings should
be printed if deprecated arguments are used.}

\item{nchar}{Deprecated argument (replaced by \code{nchar.trts}).}

\item{\dots}{Additional arguments (to catch deprecated arguments).}
}
\value{
An object of class \code{netmeta} with corresponding \code{print},
\code{summary}, \code{forest}, and \code{netrank} functions. The
object is a list containing the following components:
\item{studlab, treat1, treat2, TE, seTE}{As defined above.}
\item{seTE.adj.common, seTE.adj.random}{Standard error of treatment
  estimate, adjusted for multi-arm studies.}
\item{design}{Design of study providing pairwise comparison.}
\item{n1, n2, event1, event2, incr}{As defined above.}
\item{mean1, mean2, sd1, sd2, time1, time2}{As defined above.}
\item{sd1, sd2, time1, time2}{As defined above.}
\item{k}{Total number of studies.}
\item{m}{Total number of pairwise comparisons.}
\item{n}{Total number of treatments.}
\item{d}{Total number of designs (corresponding to the unique set
  of treatments compared within studies).}
\item{trts}{Treatments included in network meta-analysis.}
\item{k.trts}{Number of studies evaluating a treatment.}
\item{n.trts}{Number of observations receiving a treatment (if
  arguments \code{n1} and \code{n2} are provided).}
\item{events.trts}{Number of events observed for a treatment (if
  arguments \code{event1} and \code{event2} are provided).}
\item{multiarm}{Logical vector to identify pairwise comparisons
  from multi-arm studies.}
\item{n.arms}{Number of treatment arms in study providing pairwise
  comparison.}
\item{studies}{Vector with unique study labels.}
\item{narms}{Number of arms for each study.}
\item{designs}{Vector with unique designs present in the network. A
  design corresponds to the set of treatments compared within a
  study.}
\item{comparisons}{Vector with unique direct comparisons present in the
  network.}
\item{TE.nma.common, TE.nma.random}{A vector of length \emph{m} of
  consistent treatment effects estimated by network meta-analysis
  (nma) (common / random effects model).}
\item{seTE.nma.common, seTE.nma.random}{A vector of length \emph{m}
  of effective standard errors estimated by network meta-analysis
  (common / random effects model).}
\item{lower.nma.common, lower.nma.random}{A vector of length
  \emph{m} of lower confidence interval limits for consistent
  treatment effects estimated by network meta-analysis (common
  effects / random effects model).}
\item{upper.nma.common, upper.nma.random}{A vector of length
  \emph{m} of upper confidence interval limits for the consistent
  treatment effects estimated by network meta-analysis (common
  effects / random effects model).}
\item{statistic.nma.common, statistic.nma.random}{A vector of length
  \emph{m} of z-values for test of treatment effect for individual
  comparisons (common / random effects model).}
\item{pval.nma.common, pval.nma.random}{A vector of length \emph{m}
  of p-values for test of treatment effect for individual
  comparisons (common / random effects model).}
\item{leverage.common}{A vector of length \emph{m} of leverages,
  interpretable as factors by which variances are reduced using
  information from the whole network.}
\item{w.common, w.random}{A vector of length \emph{m} of weights of
  individual studies (common / random effects model).}
\item{Q.common}{A vector of length \emph{m} of contributions to
  total heterogeneity / inconsistency statistic.}
\item{TE.common, TE.random}{\emph{n}x\emph{n} matrix with estimated
  overall treatment effects (common / random effects model).}
\item{seTE.common, seTE.random}{\emph{n}x\emph{n} matrix with
  standard errors (common / random effects model).}
\item{lower.common, upper.common, lower.random,
  upper.random}{\emph{n}x\emph{n} matrices with lower and upper
  confidence interval limits (common / random effects
  model).}
\item{statistic.common, pval.common, statistic.random,
  pval.random}{\emph{n}x\emph{n} matrices with z-value and p-value
  for test of overall treatment effect (common / random
  effects model).}
\item{seTE.predict}{\emph{n}x\emph{n} matrix with standard errors
  for prediction intervals.}
\item{lower.predict, upper.predict}{\emph{n}x\emph{n} matrices with
  lower and upper prediction interval limits.}
\item{prop.direct.common, prop.direct.random}{A named vector of the
  direct evidence proportion of each network estimate. (common
  effects / random effects model).}
\item{TE.direct.common, TE.direct.random}{\emph{n}x\emph{n} matrix
  with estimated treatment effects from direct evidence (common
  effects / random effects model).}
\item{seTE.direct.common, seTE.direct.random}{\emph{n}x\emph{n}
  matrix with estimated standard errors from direct evidence (common
  effects / random effects model).}
\item{lower.direct.common, upper.direct.common, lower.direct.random,
  upper.direct.random}{\emph{n}x\emph{n} matrices with lower and upper
  confidence interval limits from direct evidence (common / random
  effects model).}
\item{statistic.direct.common, pval.direct.common, statistic.direct.random,
  pval.direct.random}{
  \emph{n}x\emph{n} matrices with z-value and p-value for test of overall
  treatment effect from direct evidence (common / random effects model).}
\item{TE.indirect.common, TE.indirect.random}{\emph{n}x\emph{n}
  matrix with estimated treatment effects from indirect evidence
  (common / random effects model).}
\item{seTE.indirect.common, seTE.indirect.random}{\emph{n}x\emph{n}
  matrix with estimated standard errors from indirect evidence
  (common / random effects model).}
\item{lower.indirect.common, upper.indirect.common,
  lower.indirect.random, upper.indirect.random}{
  \emph{n}x\emph{n} matrices with lower and upper confidence interval limits
  from indirect evidence (common / random effects model).}
\item{statistic.indirect.common, pval.indirect.common,
  statistic.indirect.random, pval.indirect.random}{
  \emph{n}x\emph{n} matrices with z-value and p-value for test of overall
  treatment effect from indirect evidence (common / random effects model).}
\item{Q}{Overall heterogeneity / inconsistency statistic.}
\item{df.Q}{Degrees of freedom for test of heterogeneity /
  inconsistency.}
\item{pval.Q}{P-value for test of heterogeneity / inconsistency.}
\item{I2, lower.I2, upper.I2}{I-squared, lower and upper confidence
  limits.}
\item{tau}{Square-root of between-study variance.}
\item{Q.heterogeneity}{Overall heterogeneity statistic.}
\item{df.Q.heterogeneity}{Degrees of freedom for test of overall
  heterogeneity.}
\item{pval.Q.heterogeneity}{P-value for test of overall
  heterogeneity.}
\item{Q.inconsistency}{Overall inconsistency statistic.}
\item{df.Q.inconsistency}{Degrees of freedom for test of overall
  inconsistency.}
\item{pval.Q.inconsistency}{P-value for test of overall
  inconsistency.}
\item{Q.decomp}{Data frame with columns 'treat1', 'treat2', 'Q',
  'df' and 'pval.Q', providing heterogeneity statistics for each
  pairwise meta-analysis of direct comparisons.}
\item{A.matrix}{Adjacency matrix (\emph{n}x\emph{n}).}
\item{X.matrix}{Design matrix (\emph{m}x\emph{n}).}
\item{B.matrix}{Edge-vertex incidence matrix (\emph{m}x\emph{n}).}
\item{L.matrix.common, L.matrix.random}{Laplacian matrix
  (\emph{n}x\emph{n}).}
\item{Lplus.matrix.common, Lplus.matrix.random}{Moore-Penrose
  pseudoinverse of the Laplacian matrix (\emph{n}x\emph{n}).}
\item{Q.matrix}{Matrix of heterogeneity statistics for pairwise
  meta-analyses, where direct comparisons exist
  (\emph{n}x\emph{n}).}
\item{G.matrix}{Matrix with variances and covariances of
  comparisons (\emph{m}x\emph{m}). G is defined as
  \strong{BL+B^t}.}
\item{H.matrix.common, H.matrix.random}{Hat matrix
  (\emph{m}x\emph{m}), defined as \strong{H = GW = BL+B^tW}.}
\item{n.matrix}{\emph{n}x\emph{n} matrix with number of
  observations in direct comparisons (if arguments \code{n1} and
  \code{n2} are provided).}
\item{events.matrix}{\emph{n}x\emph{n} matrix with number of events
  in direct comparisons (if arguments \code{event1} and
  \code{event2} are provided).}
\item{P.common, P.random}{\emph{n}x\emph{n} matrix with direct
  evidence proportions (common / random effects model).}
\item{Cov.common}{Variance-covariance matrix (common effects model)}
\item{Cov.random}{Variance-covariance matrix (random effects model)}
\item{sm, level, level.ma}{As defined above.}
\item{common, random}{As defined above.}
\item{prediction, level.predict}{As defined above.}
\item{reference.group, baseline.reference, small.values,
  all.treatments}{As defined above.}
\item{seq, tau.preset, tol.multiarm, tol.multiarm.se}{As defined
  above.}
\item{details.chkmultiarm, sep.trts, nchar.trts}{As defined above.}
\item{backtransf, title, warn, warn.deprecated}{As defined above.}
\item{call}{Function call.}
\item{version}{Version of R package netmeta used to create object.}

In addition, the following component is stored if \bold{metafor} is
used to calculate the between-study variance and argument
\code{keeprma = TRUE}:
\item{rma.tau}{R object created with \code{\link[metafor]{rma.mv}}.}
}
\description{
Network meta-analysis is a generalisation of pairwise meta-analysis
that compares all pairs of treatments within a number of treatments
for the same condition. The graph-theoretical approach for network
meta-analysis uses methods that were originally developed in
electrical network theory. It has been found to be equivalent to
the frequentist approach to network meta-analysis which is based on
weighted least squares regression (Rücker, 2012). An extension for
multi-arm studies with correlated treatment arms is also implemented
(Rücker & Schwarzer, 2025, unpublished).
}
\details{
Network meta-analysis using R package \bold{netmeta} is described
in detail in Schwarzer et al. (2015), Chapter 8.

\subsection{Network meta-analysis model}{
Let \emph{n} be the number of different treatments (nodes,
vertices) in a network and let \emph{m} be the number of existing
comparisons (edges) between the treatments. If there are only
two-arm studies, \emph{m} is the number of studies. Let TE and seTE
be the vectors of observed effects and their standard errors. Let W
be the \emph{m}x\emph{m} diagonal matrix that contains the inverse
variance 1 / seTE^2.

The given comparisons define the network structure. Therefrom an
\emph{m}x\emph{n} design matrix X (edge-vertex incidence matrix) is
formed; for more precise information, see Rücker (2012). Moreover,
the \emph{n}x\emph{n} Laplacian matrix L and its Moore-Penrose
pseudoinverse L+ are calculated (both matrices play an important
role in graph theory and electrical network theory). Using these
matrices, the variances based on both direct and indirect
comparisons can be estimated. Moreover, the hat matrix H can be
estimated by \strong{H = XL+X^tW = X(X^t W X)^+X^tW} and finally
consistent treatment effects can be estimated by applying the hat
matrix to the observed (potentially inconsistent) effects. H is a
projection matrix which maps the observed effects onto the
consistent (n-1)-dimensional subspace. This is the Aitken estimator
(Senn et al., 2013). As in pairwise meta-analysis, the Q statistic
measures the deviation from consistency. Q can be separated into
parts for each pairwise meta-analysis and a part for remaining
inconsistency between comparisons.

A simple random effects model assuming that a constant
heterogeneity variance is added to each comparison of the network
can be defined via a generalised methods of moments estimate of the
between-studies variance \eqn{\tau^2} (Jackson et al., 2012). This
is added to the observed sampling variance \code{seTE^2} of each
comparison in the network (before appropriate adjustment for
multi-arm studies). Then, as in standard pairwise meta-analysis,
the procedure is repeated with the resulting enlarged standard
errors.

For the random-effects model, the direct treatment estimates are
based on the common between-study variance \eqn{\tau^2} from the
network meta-analysis.
}

\subsection{Multi-arm studies}{
Often multi-arm studies are included in a network meta-analysis.
In multi-arm studies, the treatment effects on different
comparisons are not independent, but correlated. This is accounted
for by reweighting all comparisons of each multi-arm study. The
method is described in Rücker (2012) and Rücker and Schwarzer
(2014).

Comparisons belonging to multi-arm studies are identified by
identical study labels (argument \code{studlab}). It is therefore
important to use identical study labels for all comparisons
belonging to the same multi-arm study, e.g., study label
"Willms1999" for the three-arm study in the data example (Senn et
al., 2013). The function netmeta then automatically accounts for
within-study correlation by reweighting all comparisons of each
multi-arm study.

Note, all pairwise comparisons must be provided for a multi-arm
study. Consider a multi-arm study of \emph{p} treatments with known
variances. For this study, treatment effects and standard errors
must be provided for each of \emph{p}(\emph{p} - 1) / 2 possible
comparisons. For instance, a three-arm study contributes three
pairwise comparisons, a four-arm study even six pairwise
comparisons. Function \code{\link[meta]{pairwise}} automatically
calculates all pairwise comparisons for multi-arm studies.
}

\subsection{Studies with correlated treatment arms}{
The network meta-analysis method described in Rücker (2012) assumes that the
treatment arms of a study are independent. This assumption is justified for
parallel design trials and leads to variance consistency in multi-arm trials.
However, this assumption is violated for trials with correlated arms, for
example, split-body trials. For these trials, the variance of a contrast is
not the sum of the arm-based variances, but comes with a correlation term
which may lead to the violation of variance consistency. Using argument
\code{correlated}, an alternative method is used for studies with correlated
treatment arms (Rücker & Schwarzer, 2025, unpublished).

Argument \code{correlated}, which must be of the same length as arguments
\code{TE}, \code{seTE}, etc., is a logical vector which must be TRUE for
trials with correlated arms and FALSE otherwise. This can be easily done
using a variable with design information like
\code{correlated = design != "Parallel"}.
}

\subsection{Data formats}{
Data entry for this function is in \emph{contrast-based} format,
that is, data are given as contrasts (differences) between two
treatments (argument \code{TE}) with standard error (argument
\code{seTE}). In principle, meta-analysis functions from R package
\bold{meta}, e.g. \code{\link[meta]{metabin}} for binary outcomes or
\code{\link[meta]{metacont}} for continuous outcomes, can be used to
calculate treatment effects separately for each treatment
comparison which is a rather tedious enterprise. If data are
provided in \emph{arm-based} format, that is, data are given for
each treatment arm separately (e.g. number of events and
participants for binary outcomes), a much more convenient way to
transform data into contrast-based form is available. Function
\code{\link[meta]{pairwise}} can automatically transform data with binary
outcomes (using the \code{\link[meta]{metabin}} function from R package
\bold{meta}), continuous outcomes (\code{\link[meta]{metacont}}
function), incidence rates (\code{\link[meta]{metainc}} function), and
generic outcomes (\code{\link[meta]{metagen}} function). Additional
arguments of these functions can be provided (see help page of
function \code{\link[meta]{pairwise}}).
}

\subsection{Additional comments}{
Internally, both common and random effects models are calculated
regardless of values chosen for arguments \code{common} and
\code{random}. Accordingly, the network estimates for the random
effects model can be extracted from component \code{TE.random} of
an object of class \code{"netmeta"} even if argument \code{random =
FALSE}. However, all functions in R package \bold{netmeta} will
adequately consider the values for \code{common} and
\code{random}. E.g. function \code{\link{print.summary.netmeta}}
will not print results for the random effects model if \code{random
= FALSE}.

By default, treatment names are not abbreviated in
printouts. However, in order to get more concise printouts,
argument \code{nchar.trts} can be used to define the minimum number
of characters for abbreviated treatment names (see
\code{\link{abbreviate}}, argument \code{minlength}). R function
\code{\link{treats}} is utilised internally to create abbreviated
treatment names.

Names of treatment comparisons are created by concatenating
treatment labels of pairwise comparisons using \code{sep.trts} as
separator (see \code{\link{paste}}). These comparison names are
used in the covariance matrices \code{Cov.common} and
\code{Cov.random} and in some R functions, e.g,
\code{\link{decomp.design}}. By default, a colon is used as the
separator. If any treatment label contains a colon the following
characters are used as separator (in consecutive order):
\code{"-"}, \code{"_"}, \code{"/"}, \code{"+"}, \code{"."},
\code{"|"}, and \code{"*"}. If all of these characters are used in
treatment labels, a corresponding error message is printed asking
the user to specify a different separator.
}
}
\note{
R function \code{\link[metafor]{rma.mv}} from R package
\pkg{metafor} (Viechtbauer 2010) is called internally to estimate
the between-study variance \eqn{\tau^2} for the (restricted)
maximum likelihood method. For binary outcomes, incidence rates,
and the mean difference, the variance-covariance matrix is
calculated if arguments \code{event1}, \code{event2}, \code{n1},
and \code{n2} (binary outcomes); \code{event1}, \code{event2},
\code{time1}, and \code{time2} (incidence rates); \code{n1},
\code{n2}, \code{sd1}, and \code{sd2} (mean difference) are
provided. For datasets preprocessed with \code{\link[meta]{pairwise}}
the respective variables are selected automatically.
}
\examples{
data(smokingcessation)

# Transform data from arm-based format to contrast-based format
#
pw1 <- pairwise(list(treat1, treat2, treat3),
  event = list(event1, event2, event3), n = list(n1, n2, n3),
  data = smokingcessation, sm = "OR")

# Conduct random effects network meta-analysis
#
net1 <- netmeta(pw1, common = FALSE)
net1

\donttest{
data(Senn2013)

# Conduct common effects network meta-analysis
#
net2 <- netmeta(TE, seTE, treat1, treat2, studlab,
  data = Senn2013, sm = "MD", random = FALSE)
net2
net2$Q.decomp

# Comparison with reference group
#
print(net2, reference = "plac")

# Conduct random effects network meta-analysis
#
net3 <- netmeta(TE, seTE, treat1, treat2, studlab,
  data = Senn2013, sm = "MD", common = FALSE)
net3

# Change printing order of treatments with placebo last and use
# long treatment names
#
trts <- c("acar", "benf", "metf", "migl", "piog",
  "rosi", "sita", "sulf", "vild", "plac")
net4 <- netmeta(TE, seTE, treat1.long, treat2.long, studlab,
  data = Senn2013, sm = "MD", common = FALSE,
  seq = trts, reference = "Placebo")
print(net4, digits = 2)
}

}
\references{
Jackson D, White IR, Riley RD (2012):
Quantifying the impact of between-study heterogeneity in
multivariate meta-analyses.
\emph{Statistics in Medicine},
\bold{31}, 3805--20

Rücker G (2012):
Network meta-analysis, electrical networks and graph theory.
\emph{Research Synthesis Methods},
\bold{3}, 312--24

Rücker G, Schwarzer G (2014):
Reduce dimension or reduce weights? Comparing two approaches to
multi-arm studies in network meta-analysis.
\emph{Statistics in Medicine},
\bold{33}, 4353--69

Schwarzer G, Carpenter JR, Rücker G (2015):
\emph{Meta-Analysis with R (Use R!)}.
Springer International Publishing, Switzerland

Senn S, Gavini F, Magrez D, Scheen A (2013):
Issues in performing a network meta-analysis.
\emph{Statistical Methods in Medical Research},
\bold{22}, 169--89

Viechtbauer W (2010):
Conducting Meta-Analyses in R with the metafor Package.
\emph{Journal of Statistical Software},
\bold{36}, 1--48
}
\seealso{
\code{\link[meta]{pairwise}}, \code{\link{forest.netmeta}},
  \code{\link{netrank}}, \code{\link[meta]{metagen}}
}
\author{
Gerta Rücker \email{gerta.ruecker@uniklinik-freiburg.de}, Guido
  Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
