% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color-paletts.R
\name{segments_gradient}
\alias{segments_gradient}
\title{Draw segments colored by gradients}
\usage{
segments_gradient(
  x,
  y = NULL,
  col = colorRamp2(c("transparent", "black"), TRUE),
  lend = 1,
  ...
)
}
\arguments{
\item{x, y}{Coordinates passed to \link[grDevices:xy.coords]{grDevices::xy.coords}.}

\item{col}{Color ramp function (see \link[grDevices:colorRamp]{grDevices::colorRamp}).}

\item{lend}{Passed to \link[graphics:segments]{graphics::segments}.}

\item{...}{Further arguments passed to \code{segments}.}
}
\value{
See \link[graphics:segments]{graphics::segments}.
}
\description{
Draw segments colored by gradients
}
\examples{

set.seed(1)
x <- cbind(cumsum(rnorm(1e3, sd=.1)), cumsum(rnorm(1e3, sd=.4)))
plot(x, type="n")
segments_gradient(x)
}
