% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Catania.R
\docType{data}
\name{Catania}
\alias{Catania}
\title{Pattern of sexual contacts in AMEN study}
\format{
Four-by-four numeric matrix with dimnames.\preformatted{##           female
## male       black hispanic other white
##   black      506       32    26    69
##   hispanic    23      308    38   114
##   other       10       14    32    47
##   white       26       46    68   599
}
}
\source{
Newman, M. (2003) "Mixing patterns in networks" Arxiv:cond-mat/0209450 v2
}
\usage{
Catania
}
\description{
Contact layer of the mixing matrix of men and women in US based on "Aids in
Multi-Ethnic  Neighborhoods" (AMEN). Based on Newman (2003).
}
\examples{
data(Catania)

# assortativity
ep <- sum(Catania \%*\% Catania)
( sum(diag(Catania)) - ep ) / ( 1 - ep )
}
\references{
Catania et al. (1992) "The population-based AMEN (AIDS in Multi-Ethnic
Neighborhoods) study" \emph{American Journal of Public Health} 82, 284-287

Morris, M. (1995) "Data driven network models for the spread of infectious
disease". In D. Mollison (ed.) \emph{Epidemic Models: Their Structure and
Relation to Data}, pp. 302-322, Cambridge University Press, Cambridge

Newman, M. (2003) "Mixing patterns in networks" Arxiv:cond-mat/0209450 v2
}
\keyword{datasets}
