% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fold.R
\name{fold}
\alias{fold}
\title{Folding square matrices around the diagonal}
\usage{
fold(x, direction = c("upper", "lower"))
}
\arguments{
\item{x}{square numeric matrix}

\item{direction}{character, one of \code{"upper"} or \code{"lower"},
direction of folding}
}
\value{
Square matrix of the same \code{dim} as \code{x} with the lower
(upper) triangle folded onto the upper (lower) triangle.
}
\description{
Fold a square matrix by collapsing lower triangle on upper triangle, or vice
versa, through addition.
}
\details{
By default, for \code{direction=="upper"}, the function takes the values in
the lower triangle of \code{x} and adds them symetrically to the values in
the upper triangle. The values on the diagonal remain unchanged. The lower
triangle is filled with 0s. If \code{direction=="lower"} the upper triangle
is collapsed on to the lower triangle.
}
\examples{
(m <- matrix(1:4, 2, 2))
(f1 <- fold(m))
(f2 <- fold(m, "lower"))

stopifnot( all.equal(diag(m), diag(f1)) )
stopifnot( all.equal(diag(m), diag(f2)) )
stopifnot( all.equal(f1[1,2], m[2,1] + m[1,2]) )
stopifnot( all.equal(f2[2,1], m[2,1] + m[1,2]) )
}
\seealso{
\code{\link[=upper.tri]{upper.tri()}}, \code{\link[=lower.tri]{lower.tri()}}, \code{\link[=symmetrize]{symmetrize()}}
}
