% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nettskjema_get_form.R
\name{nettskjema_get_extra}
\alias{nettskjema_get_extra}
\title{Add additional answer data}
\usage{
nettskjema_get_extra(data, codebook, information, use_codebook = TRUE, ...)
}
\arguments{
\item{data}{tibble. Data retrieved from nettskjema}

\item{codebook}{codebook object retrieved by \code{\link{nettskjema_get_codebook}}}

\item{information}{character vector of information to add.
One or more of "order", "option", "correct" "preselected".}

\item{use_codebook}{logical. Use codebook for retrieving answers (default TRUE). If you have not
set up the codebook in nettskjema, then turning this off will return the data as is.}

\item{...}{arguments passed to \code{\link[httr]{GET}}}
}
\value{
tibble with added columns
}
\description{
The answers in the nettskjema forms
have some extra information attached
that is not returned by default.
This is for instance information on
the order of the answer options, the true
text, whether the answer is correct or
if it is preselected. This function makes
it possible to retrieve and add this
information to the nettskjema data, using
the codebook.
}
\examples{
\dontrun{
form_id <- 100000

my_data <- nettskjema_get_data(form_id)
cb <-  nettskjema_get_codebook(form_id)

my_data <- nettskjema_get_extra(my_data, cb, "order")

}
}
