% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nettskjema_write.R
\name{nettskjema_write_codebook}
\alias{nettskjema_write_codebook}
\alias{nettskjema_write_codebook.default}
\alias{nettskjema_write_codebook.nettskjema_codebook_raw}
\alias{nettskjema_write_codebook.nettskjema_codebook}
\title{Write codebook to file}
\usage{
nettskjema_write_codebook(codebook, file, ...)

\method{nettskjema_write_codebook}{default}(codebook, file, ...)

\method{nettskjema_write_codebook}{nettskjema_codebook_raw}(codebook, file, pretty = TRUE, ...)

\method{nettskjema_write_codebook}{nettskjema_codebook}(codebook, file, sep = "\\t", ...)
}
\arguments{
\item{codebook}{object of class nettskjema_codebook}

\item{file}{filename or path}

\item{...}{arguments to \code{\link[jsonlite]{write_json}} or \code{\link[utils]{write.table}}}

\item{pretty}{logical. If writing json-file, make it pretty}

\item{sep}{character. If writing text table, column delimiter.}
}
\value{
no return value. Writes a file to path.
}
\description{
Save codebook information to a
file for safe keeping. Depending
on the type of codebook (raw or tidy)
the file will either be stored as a
json-file through \code{\link[jsonlite]{write_json}}
or a text table through \code{\link[utils]{write.table}}.
}
\details{
Given the two types of codebooks, writes different
       types of files.
\itemize{
\item{codebook}{ - writes a tab-separated table}
\item{codebook_raw}{ - writes a json-file}
}
}
\examples{
\dontrun{
form_id <- 1100000
my_cb <- nettskjema_get_codebook(form_id)
nettskjema_write_codebook(my_cb, "my/path/codebook_110000.txt")
}
}
