% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randABC-package.R
\docType{package}
\name{networkABC-package}
\alias{networkABC-package}
\alias{networkABC}
\title{networkABC: Network Reverse Engineering with Approximate Bayesian Computation}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

We developed an inference tool based on approximate Bayesian computation to decipher network data and assess the strength of the inferred links between network's actors. It is a new multi-level approximate Bayesian computation (ABC) approach. At the first level, the method captures the global properties of the network, such as a scale-free structure and clustering coefficients, whereas the second level is targeted to capture local properties, including the probability of each couple of genes being linked. Up to now, Approximate Bayesian Computation (ABC) algorithms have been scarcely used in that setting and, due to the computational overhead, their application was limited to a small number of genes. On the contrary, our algorithm was made to cope with that issue and has low computational cost. It can be used, for instance, for elucidating gene regulatory network, which is an important step towards understanding the normal cell physiology and complex pathological phenotype. Reverse-engineering consists in using gene expressions over time or over different experimental conditions to discover the structure of the gene network in a targeted cellular process. The fact that gene expression data are usually noisy, highly correlated, and have high dimensionality explains the need for specific statistical methods to reverse engineer the underlying network.
}
\references{
\emph{networkABC: An inference tool for networks based on approximate Bayesian computation}, Myriam Maumy-Bertrand, Frédéric Bertrand, preprint.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://fbertran.github.io/networkABC/}
  \item \url{https://github.com/fbertran/networkABC/}
  \item Report bugs at \url{https://github.com/fbertran/networkABC/issues/}
}

}
\author{
\strong{Maintainer}: Frederic Bertrand \email{frederic.bertrand@utt.fr} (\href{https://orcid.org/0000-0002-0837-8281}{ORCID})

Authors:
\itemize{
  \item Myriam Maumy-Bertrand \email{myriam.maumy@utt.fr} (\href{https://orcid.org/0000-0002-4615-1512}{ORCID})
}

Other contributors:
\itemize{
  \item Khadija Musayeva \email{khadija@musayeva.net} [contributor]
  \item Nicolas Jung \email{nicolas.jung@unistra.fr} [contributor]
  \item  Université de Strasbourg [copyright holder]
  \item  CNRS [copyright holder]
}

}
\keyword{internal}
