% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantile.nifti.R
\name{quantile.nifti}
\alias{quantile.nifti}
\alias{quantile.anlz}
\title{Sample Quantiles}
\usage{
\method{quantile}{nifti}(x, ..., mask)

\method{quantile}{anlz}(x, ..., mask)
}
\arguments{
\item{x}{Object of class \code{nifti}}

\item{...}{Arguments passed to \code{\link{quantile}}}

\item{mask}{object to subset the image.  If missing, then all 
values of the image are used}
}
\value{
Output of \code{\link{quantile}}
}
\description{
Computes sample 
quantiles for an image, with the option of a mask.
}
\examples{
img = nifti(array(rnorm(10^3), dim = rep(10, 3)))
mask = img > 0
quantile(img, mask = mask)
}
