% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neuroimagene_pkg.R
\name{neuroimaGene}
\alias{neuroimaGene}
\title{Main neuroimaGene query}
\usage{
neuroimaGene(
  gene_list,
  modality = "T1",
  atlas = "Desikan",
  mtc = "BH",
  nidps = NA,
  filename = NA,
  verbose = FALSE,
  vignette = FALSE
)
}
\arguments{
\item{gene_list}{List of genes to work as inputs. There are no defaults.}

\item{modality}{Neuroimaging modality for NIDP query. Defaults to T1 structural NIDPs.}

\item{atlas}{Neuroimaging parcellation atlas for NIDP query. Defaults to Desikan structural atlas.}

\item{mtc}{Statistical multiple testing correction for NIDP query. Defaults to BH for the Benjamini Hochberg False Discovery Rate.}

\item{nidps}{optional user defined vector of target NIDPs to query. These can be obtained from the listNIDPnames() function.}

\item{filename}{optional user defined filename for writing neuroimaGene output to a file.}

\item{verbose}{print runtime messages to R console. Default to FALSE}

\item{vignette}{use for building vignette on installation. Default to FALSE}
}
\value{
a neuroimaGene object: data table with all significant associations between the user provided genes and the UKB NIDPs satisfying the multiple testing correction and atlas/modality/name filters.
}
\description{
Using a user supplied vector of genes (Ensembl ID's or HUGO names), this function queries the NeuroimaGene resource for all statistically significant GReX-NIDP associations and returns all findings as a data.table.
}
\examples{
gene_list <- c('TRIM35', 'PROSER3', 'EXOSC6', 'PICK1', 'UPK1A', 'ESPNL', 'ZIC4')
ng <- neuroimaGene(gene_list, atlas = NA, mtc = 'BH', vignette = TRUE)

}
\keyword{neuroimaging}
