% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neuro_vis.R
\name{neuro_vis}
\alias{neuro_vis}
\title{2D visualization plot of a neuroimaGene object}
\usage{
neuro_vis(
  ng_obj,
  atlas = "Desikan",
  lowcol = "red2",
  midcol = "white",
  highcol = "royalblue2",
  title = NA
)
}
\arguments{
\item{ng_obj}{NeuroimaGene object produced by neuroimaGene() function}

\item{atlas}{desired atlas for visualization. Desikan (default), Subcortex, DKT, Destrieux.}

\item{lowcol}{color for low end of Zscore spectrum. Default is dark red}

\item{midcol}{color for middle of Zscore spectrum. Default is white}

\item{highcol}{color for top end of Zscore spectrum. Default is blue4}

\item{title}{optional title tag for the plot}
}
\value{
class: ggplot object depicting 2D visualization of the NIDPs from the neuroimaGene object portrayed on the brain and shaded by mean effect size.
}
\description{
Generates a 2D visualization plot of the neuroimaGene object. Neuroimaging
regions are defined by the atlas parameter and colored according to the
magnitude and direction of the aggregate effect from each gene in the
NeuroimaGene object. Colors can be defined by the user.
}
\examples{
gene_list <- c('TRIM35', 'PROSER3', 'EXOSC6', 'PICK1', 'UPK1A', 'ESPNL', 'ZIC4')
ng <- neuroimaGene(gene_list, atlas = NA, mtc = 'BH', vignette = TRUE)
neuro_vis(ng, atlas = 'DKT')


}
\keyword{neuroimaging}
