% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/nhanes.R
\name{nhanesTableVars}
\alias{nhanesTableVars}
\title{Displays a list of variables in the specified NHANES table.}
\usage{
nhanesTableVars(nh_surveygroup, nh_table, truncated = FALSE, nchar = 100)
}
\arguments{
\item{nh_surveygroup}{The type of survey (DEMOGRAPHIC, DIETARY, EXAMINATION, LABORATORY, QUESTIONNAIRE).
Abbreviated terms may also be used: (DEMO, DIET, EXAM, LAB, Q).}

\item{nh_table}{The name of the specific table to retrieve.}

\item{truncated}{If true then only the variable names and descriptions are returned, which is often sufficient.}

\item{nchar}{The number of characters in the Variable Description to print. Values are limited to 0<=nchar<=127.
This is used to enhance readability, cause variable descriptions can be very long.}
}
\value{
The names of the tables in the specified survey group
}
\description{
Enables quick display of table variables and their definitions.
}
\details{
Data are retrieved via web scraping using html wrappers from package rvest.
Each data table contains multiple, sometimes more than 100, fields. It is helpful to list the field
descriptions to ascertain quickly if a data table is of interest.
}
\examples{
nhanesTableVars('LAB', 'CBC_E')
nhanesTableVars('EXAM', 'OHX_E', truncated=TRUE)
}

