% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhanes.R
\name{nhanesFromURL}
\alias{nhanesFromURL}
\title{Parse NHANES doc URL}
\usage{
nhanesFromURL(
  url,
  translated = TRUE,
  cleanse_numeric = TRUE,
  nchar = 128,
  adjust_timeout = TRUE
)
}
\arguments{
\item{url}{URL of XPT file to be downloaded}

\item{translated}{logical, whether variable codes should be translated}

\item{cleanse_numeric}{Logical flag. If \code{TRUE}, some special
codes in numeric variables, such as \sQuote{Refused} and
\sQuote{Don't know} will be converted to \code{NA}.}

\item{nchar}{integer, labels are truncated after this}

\item{adjust_timeout}{Typically a logical flag indicating whether
the default \code{\link{download.file}} timeout option should be
adjusted by taking into account the size of the file to be
downloaded, as reported by the server. The value can also be a
positive numeric value, in which case it is used as a further
multiplicative factor for the default calculation.}
}
\value{
data frame
}
\description{
Download an NHANES table from URL
}
\details{
Downloads an NHANES table from a URL and returns it as a data frame
}
