% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{select_point_overlay}
\alias{select_point_overlay}
\title{Select features clipped by a point buffer around a point}
\usage{
select_point_overlay(pnt, sp, buffer_dist = 0.05)
}
\arguments{
\item{pnt}{geographic point of class sfc}

\item{sp}{list of sf data frames}

\item{buffer_dist}{numeric buffer in units of coordinate degrees}
}
\description{
Select features clipped by a point buffer around a point
}
\examples{
\dontrun{
wk <- wikilake::lake_wiki("Gull Lake (Michigan)")
pnt <- sf::st_sfc(sf::st_point(c(wk$Lon, wk$Lat)))
sf::st_crs(pnt) <- 4326
sp <- lapply(c("NHDWaterbody", "NHDFlowLine"),
          function(x) nhd_plus_load(vpu = 4, dsn = x))
names(sp) <- c("NHDWaterbody", "NHDFlowLine")
qry <- select_point_overlay(pnt = pnt, sp = sp, buffer_dist = 0.05)
plot(qry$NHDWaterbody$geometry)

}
}
