% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.R
\name{tip_reaches}
\alias{tip_reaches}
\title{Return tip reaches from a network}
\usage{
tip_reaches(network = NA)
}
\arguments{
\item{network}{sf lines collection. optional. See Details section.}
}
\value{
An sf data frame with LINESTRING geometries
}
\description{
A tip reach is a stream flowline with no upstream connections.
}
\examples{
\dontrun{

coords  <- data.frame(lat = 41.42217, lon = -73.24189)
network <- nhd_plus_query(lon = coords$lon, lat = coords$lat,
  dsn = "NHDFlowline", buffer_dist = units::as_units(5, "km"))$sp$NHDFlowline
t_reaches <- tip_reaches(network = network)

plot(network$geometry)
plot(t_reaches$geometry, col = "red", add = TRUE)
}
}
