% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_nhdplushr.R
\name{get_nhdplushr}
\alias{get_nhdplushr}
\title{Get NHDPlus HiRes}
\usage{
get_nhdplushr(
  hr_dir,
  out_gpkg = NULL,
  layers = c("NHDFlowline", "NHDPlusCatchment"),
  pattern = ".*GDB.gdb$",
  check_terminals = TRUE,
  overwrite = FALSE,
  keep_cols = NULL,
  ...
)
}
\arguments{
\item{hr_dir}{character directory with geodatabases (gdb search is recursive)}

\item{out_gpkg}{character path to write output geopackage}

\item{layers}{character vector with desired layers to return.
c("NHDFlowline", "NHDPlusCatchment") is default.
Choose from:
c("NHDFlowline", "NHDPlusCatchment", "NHDWaterbody", "NHDArea", "NHDLine",
"NHDPlusSink", "NHDPlusWall", "NHDPoint", "NHDPlusBurnWaterbody",
"NHDPlusBurnLineEvent", "HYDRO_NET_Junctions",
"WBDHU2", "WBDHU4","WBDHU6", "WBDHU8" "WBDHU10", "WBDHU12", "WBDLine")
Set to NULL to get all available.}

\item{pattern}{character optional regex to select certain files in hr_dir}

\item{check_terminals}{boolean if TRUE, run \link{make_standalone} on output.}

\item{overwrite}{boolean should the output overwrite? If false and the output layer
exists, it will be read and returned so this function will always return data even
if called a second time for the same output. This is useful for workflows. Note that
this will NOT delete the entire GeoPackage. It will overwite on a per layer basis.}

\item{keep_cols}{character vector of column names to keep in the output. If NULL,
all will be kept.}

\item{...}{parameters passed along to \link{get_hr_data}
for "NHDFlowline" layers.}
}
\value{
Response is a list of sf data.frames containing output that may also be written
to a geopackage for later use.
}
\description{
Get NHDPlus HiRes
}
\details{
NHDFlowline is joined to value added attributes prior to being
returned.
Names are not modified from the NHDPlusHR geodatabase.
Set layers to "NULL" to get all layers.
}
\examples{
\donttest{
# Note this will download a lot of data to a temp directory.
# Change 'tempdir()' to your directory of choice.
download_dir <- download_nhdplushr(tempdir(), c("0302", "0303"))

get_nhdplushr(download_dir, file.path(download_dir, "nhdplus_0302-03.gpkg"))

get_nhdplushr(download_dir,
              file.path(download_dir, "nhdplus_0302-03.gpkg"),
              layers = NULL, overwrite = TRUE)

get_nhdplushr(download_dir,
              file.path(download_dir, "nhdplus_0302-03.gpkg"),
              layers = "NHDFlowline", overwrite = TRUE,
              min_size_sqkm = 10, simp = 10, proj = "+init=epsg:5070")

}
}
