% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_network.R
\name{get_DD}
\alias{get_DD}
\title{Navigate Downstream with Diversions}
\usage{
get_DD(network, comid, distance = NULL)
}
\arguments{
\item{network}{data.frame NHDPlus flowlines including at a minimum:
COMID, DnMinorHyd, DnHydroseq, and Hydroseq.}

\item{comid}{integer identifier to start navigating from.}

\item{distance}{numeric distance in km to limit how many
COMIDs are returned.
The COMID that exceeds the distance specified is returned.
The longest of the diverted paths is used for limiting distance.}
}
\value{
integer vector of all COMIDs downstream of the starting COMID
}
\description{
Traverse NHDPlus network downstream with diversions
NOTE: This algorithm may not scale well in large watersheds.
For reference, the lower Mississippi will take over a minute.
}
\examples{
library(sf)
start_COMID <- 11688818
sample_flines <- read_sf(system.file("extdata",
                                     "petapsco_flowlines.gpkg",
                                     package = "nhdplusTools"))
DD_COMIDs <- get_DD(sample_flines, start_COMID, distance = 4)
plot(dplyr::filter(sample_flines, COMID \%in\% DD_COMIDs)$geom,
     col = "red", lwd = 2)

DM_COMIDs <- get_DM(sample_flines, start_COMID, distance = 4)
plot(dplyr::filter(sample_flines, COMID \%in\% DM_COMIDs)$geom,
     col = "blue", add = TRUE, lwd = 2)

}
