% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_nhdplus.R
\name{get_tocomid}
\alias{get_tocomid}
\title{Get tocomid}
\usage{
get_tocomid(
  x,
  return_dendritic = TRUE,
  missing = 0,
  remove_coastal = TRUE,
  add = TRUE
)
}
\arguments{
\item{x}{data.frame with comid, tonode, fromnode, and (optionally)
divergence and terminalpa attributes.}

\item{return_dendritic}{logical if TRUE, a divergence attribute is required
(2 indicates diverted path, 1 is main) and diverted paths will be treated
as headwaters. If this is FALSE, the return value is a data.frame including
the comid and tocomid attributes.}

\item{missing}{integer value to use for terminal nodes.}

\item{remove_coastal}{logical remove coastal features prior to generating
tocomid values? ftype or fcode are required if `TRUE`. fcode == 56600 or
fcode == "Coastline" will be fremoved.}

\item{add}{logical if TRUE, a tocomid column will be added, otherwise
a data.frame with two columns will be returned.}
}
\value{
data.frame containing comid and tocomid attributes or all
attributes provided with comid and tocomid in the first and second columns..
}
\description{
Given flowlines with fromnode and tonode attributes,
will return a toid attribute that is the result of joining
tonode and fromnode attributes. In the case that a terminalpa
attribute is included, the join is executed by terminalpa group.
This is done grouped by terminalpathID because duplicate node
ids have been encountered accross basins in some datasets. If
`remove_coastal` is `TRUE` (the default) either ftype or fcode are
required.
}
\examples{
source(system.file("extdata", "sample_flines.R", package = "nhdplusTools"))

tocomid <- get_tocomid(sample_flines)

tocomid <- get_tocomid(sample_flines, return_dendritic = FALSE)

}
