% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_path_lengths.R
\name{get_partial_length}
\alias{get_partial_length}
\title{Get Partial Flowline Length}
\usage{
get_partial_length(hl, net = NULL, fl = NULL)
}
\arguments{
\item{hl}{list containing a hydrologic location with names reachcode
and reach_meas.}

\item{net}{data.frame containing a flowpath network with reachcode,
frommeas, tomeas, and lengthkm attributes. Not required if `fl` is
provided.}

\item{fl}{data.frame containing one flowline that corresponds to the
reachcode and measure of `hl`. Not required if `hl` is provided.}
}
\value{
list containing `up` and `dn` elements with numeric length in
km.
}
\description{
Finds the upstream and downstream lengths along a given
flowpath (flowline in nhdplus terminology). Internally, the function
rescales the reach measure to a flowpath measure and applies that
rescaled measure to the length of the flowpath.
}
\examples{

source(system.file("extdata", "walker_data.R", package = "nhdplusTools"))
hydro_location <- list(comid = 5329339,
                       reachcode = "18050005000078",
                       reach_meas = 30)

(pl <- get_partial_length(hydro_location, walker_flowline))

hydro_location <- sf::st_sf(hydro_location,
                            geom = nhdplusTools::get_hydro_location(data.frame(hydro_location),
                                                                    walker_flowline))

net <- navigate_network(hydro_location,
                        mode = "DM", network = walker_flowline,
                        distance_km = 4, trim_start = TRUE)

plot(sf::st_geometry(walker_flowline[walker_flowline$COMID == hydro_location$comid,]))
plot(sf::st_geometry(hydro_location), add = TRUE)
plot(sf::st_geometry(net), add = TRUE, col = "blue", lwd = 2)

sf::st_length(net)
pl$dn

}
