% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhl_get_data.R
\name{nhl_from_json}
\alias{nhl_from_json}
\title{Get URL using \code{fromJSON}}
\usage{
nhl_from_json(
  url,
  flatten = getOption("nhlapi_flatten"),
  silent = getOption("nhlapi_try_silent"),
  retries = getOption("nhlapi_get_retries"),
  retrySleep = getOption("nhlapi_get_retry_sleep"),
  noRetryPatt = getOption("nhlapi_get_noretry")
)
}
\arguments{
\item{url}{\code{character(1)}, the URL to get the data from.}

\item{flatten}{\code{logical(1)}, if \code{TRUE} (default) automatically
flattens nested data frames into a single non-nested data frame.}

\item{silent}{\code{logical(1)}, passed to \verb{[try()]}.}

\item{retries}{\code{integer(1)}, number of retries in case of failed
data retrieval (\code{0L} for no no retries).}

\item{retrySleep}{\code{integer(1)}, number of seconds to
\verb{[Sys.sleep()]} in between retries.}

\item{noRetryPatt}{\code{character(1)}, string pattern. If the error
condition's message contains this pattern, there will be no
retries. Useful for e.g. \code{404} returns where retries are likely
useless.}
}
\value{
\code{list}, retrieved data if succeeded, a \code{try-error} class
object otherwise.
}
\description{
Get URL using \code{fromJSON}
}
