% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhl_teams.R
\name{nhl_teams_rosters}
\alias{nhl_teams_rosters}
\title{Get rosters for teams}
\usage{
nhl_teams_rosters(teamIds = NULL, seasons = NULL)
}
\arguments{
\item{teamIds}{\code{integer()}, ids of the teams or \code{NULL} (default)
for all teams. As of end of 2019, the valid team ids seem to be
in the \code{1:54} range.}

\item{seasons}{\code{numeric()}, \code{integer()} or \code{character()},
vector of starting years of desired seasons in \code{YYYY}
format, e.g. \code{1995} or \code{"1995"} for season 1995-1996.
Accepts vectors such as \code{c(1995:2000, 2010)} to generate
multiple seasons.

Alternatively, also accepts \code{character()} with seasons in the
format \code{"YYYYZZZZ"}, where \code{ZZZZ = YYYY + 1}, e.g. \code{"19951996"}.
This is the format that ultimately gets sent to the NHL API.

Some API endpoints, notably \code{seasons} exposed via \code{\link[=nhl_seasons]{nhl_seasons()}}
also allow the value \code{"current"} to passed. This value will be
returned unchanged.}
}
\value{
\code{data.frame}, with an element called \code{roster.roster}
that in itself is a \code{data.frame} with the roster data.
}
\description{
Get rosters for teams
}
\examples{
 \dontrun{
  # Current rosters for all teams
  nhl_teams_rosters()

  # Rosters for all teams for past seasons
  nhl_teams_rosters(seasons = c("19931994", "19931994"))

  # Roster for Devils and Islanders
  nhl_teams_rosters(
    teamIds = 1:2,
    seasons = c("19931994", "19931994")
  )
}
}
