% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhl_utils.R
\name{util_prepare_player_ids}
\alias{util_prepare_player_ids}
\title{Prepare player ids based on player names}
\usage{
util_prepare_player_ids(playerNames, map = getOption("nhlapi_player_map"))
}
\arguments{
\item{playerNames}{\code{character()}, vector of one or more player names.
Not case sensitive for convenience.}

\item{map}{\code{data.frame}, with 2 columns:
\itemize{
\item \code{nameMd5}: \code{character()} of hashed player names
\item \code{id}: \code{integer()} of player ids used by the NHL API
}}
}
\value{
\code{integer()}, named vector of found valid player
ids, those not found omitted.
}
\description{
Prepare player ids based on player names
}
\examples{
  nhlapi:::util_prepare_player_ids(c("joe sakic", "fake player"))
}
