% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-linear.R
\name{get_step_majorizer}
\alias{get_step_majorizer}
\title{Piecewise constant (step) majorizer for K-Lipschitz functions over an interval}
\usage{
get_step_majorizer(fun, breaks, is_monotone = TRUE, K = 0)
}
\arguments{
\item{fun}{A function object with a single argument \code{x}}

\item{breaks}{(vector) The set of \code{M+1} boundaries for the \code{M} subintervals in \code{x}}

\item{is_monotone}{(boolean) Is the function monotone? (Default is \code{TRUE}.)}

\item{K}{(double) A non-negative number for the Lipschitz cone. (Default is 0.)}
}
\value{
A vector of length \code{M} with the values of the piecewise constant majorizer
}
\description{
Return a piecewise constant (step) majorizer for K-Lipschitz functions
over an interval.
}
\examples{
get_step_majorizer(fun = abs, breaks = -5:5, is_monotone = FALSE, K = 1)
}
