% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ztdraw_intensity.R
\name{ztdraw_intensity}
\alias{ztdraw_intensity}
\title{Simulate \code{size} samples from a zero-truncated non homogeneous Poisson Point Process (zt-NHPPP) from
(t0, t_max) (thinning method)}
\usage{
ztdraw_intensity(
  lambda,
  lambda_maj = NULL,
  exp_maj = FALSE,
  range_t = c(0, 10),
  rng_stream = NULL,
  atmost1 = FALSE
)
}
\arguments{
\item{lambda}{(function) the instantaneous rate of the NHPPP.
A continuous function of time.}

\item{lambda_maj}{(double, vector) the intercept and optional slope of the majorizing
linear (if \code{exp_maj = FALSE}) or log-linear (if \code{exp_maj = TRUE}) function in \code{range_t}.}

\item{exp_maj}{(boolean) if \code{TRUE} the majorizer is \code{exp(alpha + beta * t)}}

\item{range_t}{(vector, double) min and max of the time interval.}

\item{rng_stream}{(\code{rstream}) an \code{rstream} object or \code{NULL}}

\item{atmost1}{(boolean) draw at most 1 event time}
}
\value{
a vector of at least 1 event times
}
\description{
Sample zero-truncated NHPPP intensity times using the thinning method, optionally using
an \code{rstream} generator
}
\examples{
x <- ztdraw_intensity(lambda = function(t) 1 + sin(t))
}
