% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NDVI.R
\name{NDVI}
\alias{NDVI}
\title{NDVI - Normalized Difference Vegetation Index}
\usage{
NDVI(R, NIR)
}
\arguments{
\item{R}{A raster layer object with the reflectance values for the Red band.}

\item{NIR}{A raster layer object with the reflectance values for the Near Infrared band.}
}
\value{
NDVI - Normalized Difference Vegetation Index.
}
\description{
NDVI is used to quantify vegetation greenness and is useful in understanding vegetation density and assessing changes in plant health. This function requires the Red and Near Infrared values.
}
\examples{
library(raster)
path_files <- system.file("extdata/", package="nightmares")
bands <- stack(list.files(path_files,".tif", full.names=TRUE))
x <- ref_oli(bands, sun.elev= 67.97)
NDVI(x[[4]], x[[5]])

}
\references{
\url{https://www.usgs.gov/core-science-systems/nli/landsat/landsat-surface-reflectance-derived-spectral-indices}.
\url{https://www.geo.university/pages/spectral-indices-with-multispectral-satellite-data}.
}
