% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alb_oli.R
\name{alb_oli}
\alias{alb_oli}
\title{Albedo}
\usage{
alb_oli(x, method = c(Chemin, Liang, Olmedo, Silva, Tasumi))
}
\arguments{
\item{x}{A raster stack containing the reflectance values of the first seven Landsat OLI bands.}

\item{method}{Specify the method to be used (Chemin, Liang, Olmedo, Silva or Tasumi)}
}
\value{
A raster layer object with the Albedo values.
}
\description{
This function is used to Convert Reflectance values to Albedo.
}
\examples{
library(raster)
path_files <- system.file("extdata/", package="nightmares")
x <- stack(list.files(path_files,".tif", full.names=TRUE))
alb_oli(x, method="Chemin")
alb_oli(x, method="Liang")
alb_oli(x, "Tasummi")

}
\references{
Chemin Method, please see i.albedo function (GRASS). Only for OLI images.

Liang, S. 2000. Narrowband to broadband conversions of land surface albedo I: Algorithms. Remote Sensing of Environment, 76(2), 213-238.

Olmedo et al., 2016. water: Tools and functions to estimate actual evapotranspiration Using land surface energy balance models in R. The R journal, 8(2), 352-369.

Silva et al., 2016. Procedures for calculation of the albedo with OLI-Landsat 8 images: Application to the Brazilian semi-arid. Revista Brasileira de Engenharia Agrícola e Ambiental, 20(1), 3-8.

Tasumi et al., 2008. At-Surface Reflectance and Albedo from Satellite for Operational Calculation of Land Surface Energy Balance. Journal of Hydrologic Engineering, 13, 51-63.
}
