\name{nilde-package}
\alias{nilde-package}
\alias{nilde}
\docType{package}
\title{
\packageTitle{nilde}
}
\description{
\code{nilde} provides functions for enumerating all existing nonnegative integer solutions of a linear Diophantine equation. The package also includes functions for solving 0-1, bounded and unbounded knapsack problems; 0-1, bounded and unbounded subset sum problems; and a problem of additive partitioning of natural numbers. The algorithm is based on a generating function of Hardy and Littlewood used by Voinov and Nikulin (1997). 
}
%\details{

%The DESCRIPTION file:
%~~\packageDESCRIPTION{nilde}
%~~\packageIndices{nilde}
%~~ An overview of how to use the package, including the most important ~~
%~~ functions ~~
%}
\author{
\packageAuthor{nilde}

Maintainer: \packageMaintainer{nilde}
}
\references{
Voinov, V. and Nikulin, M. (1995) Generating functions, problems of additive number theory, and some statistical applications. Revue Roumaine de \enc{Mathématiques}{Mathematiques} Pures et \enc{Appliquées}{Appliquees}, 40(2), 107-147

Voinov, V. and Nikulin, M. (1997) On a subset sum algorithm and its probabilistic and other applications. In: Advances in combinatorial methods and applications to probability and statistics, Ed. N. Balakrishnan, \enc{Birkhäuser}{Birkhauser}, Boston, 153-163

Voinov, V. and Pya, N. (2006) A Remark on the Non-Uniqueness of a Non-Negative Integer Solution of a System of Linear Diophantine Equations with Applications to Integer Programming, Genetics, Reliability. Central Asian Journal of Management, Economics and Social Research (ISSN 1815-3356) 5(1-2), 42-47.

Voinov, V. and Pya, N. (2017) R-software for additive partitioning of positive integers. Mathematical Journal (ISSN 1682-0525), 17(1), 69-76 

}
%~~ Optionally other standard keywords, one per line, from file KEYWORDS in ~~
%~~ the R documentation directory ~~
\keyword{ package }
%\seealso{
%~~ Optional links to other man pages, e.g. ~~
%~~ \code{\link[<pkg>:<pkg>-package]{<pkg>}} ~~
%}
\examples{
## see examples for nlde and get.partitions
}
