% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmvn.R
\name{rmvn}
\alias{rmvn}
\title{Simulate Multivariate Normal}
\usage{
rmvn(n, mu = 0, sigma = matrix(1))
}
\arguments{
\item{n}{Number of simulation replicates.}

\item{mu}{Mean vector.}

\item{sigma}{Variance-covariance matrix.}
}
\value{
Matrix of size n by \code{length(mu)}, each row corresponding to a replicate.
}
\description{
Simulate random variables from a multivariate normal distribution.
}
\details{
Use Cholesky decomposition of \code{sigma}, from \code{\link[base]{chol}}.
}
\examples{
x <- rmvn(100, c(1,2), matrix(c(1,1,1,4), ncol = 2))

}
\seealso{
\code{\link[stats]{rnorm}}
}

