% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in Rtmp3xd4YE/filefb25d8e9933
\name{t}
\alias{dt_nonstandard}
\alias{pt_nonstandard}
\alias{qt_nonstandard}
\alias{rt_nonstandard}
\alias{t}
\title{The t Distribution}
\usage{
dt_nonstandard(x, df = 1, mu = 0, sigma = 1, log = FALSE)

rt_nonstandard(n, df = 1, mu = 0, sigma = 1)

pt_nonstandard(q, df = 1, mu = 0, sigma = 1, lower.tail = TRUE,
  log.p = FALSE)

qt_nonstandard(p, df = 1, mu = 0, sigma = 1, lower.tail = TRUE,
  log.p = FALSE)
}
\arguments{
\item{x}{vector of values.}\item{df}{vector of degrees of freedom values.}\item{mu}{vector of location values.}\item{sigma}{vector of scale values.}\item{log}{logical; if TRUE, probability density is returned on the log scale.}\item{n}{number of observations.}\item{q}{vector of quantiles.}\item{lower.tail}{logical; if TRUE (default) probabilities are \eqn{P[X \le x]}; otherwise, \eqn{P[X > x]}.}\item{log.p}{logical; if TRUE, probabilities p are given by user as log(p).}\item{p}{vector of probabilities.}}\value{
\code{dt_nonstandard} gives the density, \code{pt_nonstandard} gives the distribution
function, \code{qt_nonstandard} gives the quantile function, and \code{rt_nonstandard}
generates random deviates.
}
\description{
Density, distribution function, quantile function and random generation
for the t distribution with \code{df} degrees of freedom,
allowing non-zero location, \code{mu},
and non-unit scale, \code{sigma}
}
\details{
See Gelman et al., Appendix A or the BUGS manual for mathematical details.
}
\examples{
x <- rt_nonstandard(50, df = 1, mu = 5, sigma = 1)
dt_nonstandard(x, 3, 5, 1)
}
\author{
Christopher Paciorek
}
\references{
Gelman, A., Carlin, J.B., Stern, H.S., and Rubin, D.B. (2004) \emph{Bayesian Data Analysis}, 2nd ed. Chapman and Hall/CRC.
}
\seealso{
\link{Distributions} for other standard distributions
}

