% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in Rtmp9wH6ZH/file2ef7725fe91c
\name{nimCat}
\alias{nimCat}
\title{cat function for use in nimbleFunctions}
\usage{
nimCat(...)
}
\arguments{
\item{...}{an arbitrary set of arguments that will be printed in sequence.}
}
\description{
cat function for use in nimbleFunctions
}
\details{
\code{cat} in nimbleFunction run-code imitates the R function \code{\link{cat}}.  It prints its arguments in order.  No newline is inserted, so include \code{"\n"} if one is desired.

When an uncompiled nimbleFunction is executed, R's \code{cat} is used.  In a compiled nimbleFunction, a C++ output stream is used that will generally format output similarly to R's \code{cat}. Non-scalar numeric objects can be included, although their output will be formatted slightly different in uncompiled and compiled nimbleFunctions.

In nimbleFunction run-time code, \code{cat} is identical to \code{print} except the latter appends a newline at the end.

\code{nimCat} is the same as \code{cat}, and the latter is converted to the former when a nimbleFunction is defined.
}
\examples{
ans <- matrix(1:4, nrow = 2) ## R code, not NIMBLE code
nimCat('Answer is ', ans) ## would work in R or NIMBLE
}
\seealso{
\code{\link{print}}
}

