% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configuration.R
\name{buildHMC}
\alias{buildHMC}
\title{Build HMC}
\usage{
buildHMC(model, nodes = character(), control = list(), print = TRUE, ...)
}
\arguments{
\item{model}{A nimble model, as returned by `nimbleModel`}

\item{nodes}{A character vector of stochastic node names to be sampled. If an empty character vector is provided (the default), then all stochastic non-data nodes will be sampled.  An HMC sampler will be applied to all continuous-valued non-data nodes, and nimble's default sampler will be assigned for all discrete-valued nodes.}

\item{control}{Optional named list of control parameters to be passed as the `control` argument to `sampler_HMC`, and also as the control argument for any samplers assigned to discrete-valued nodes.  See `help(sampler_HMC)` or `help(samplers)` for details.}

\item{print}{Logical argument specifying whether to print the montiors and samplers.  Default is TRUE.}

\item{...}{Other arguments that will be passed to `configureHMC`.}
}
\value{
An object of class `MCMC`.
}
\description{
Build an MCMC algorithm which applies HMC sampling to continuous-valued dimensions
}
\details{
This is the most direct way to create an MCMC algorithm using HMC sampling in nimble.  This will create a compilable, executable MCMC algorithm, with HMC sampling assigned to all continuous-valued model dimensions, and nimble's default sampler assigned to all discrete-valued dimensions.  The `nodes` argument can be used to control which model nodes are assigned samplers.  Use this if you don't otherwise need to modify the MCMC configuration.
}
\examples{
nimbleOptions(enableDerivs = TRUE)

code <- nimbleCode({
    b0 ~ dnorm(0, 0.001)
    b1 ~ dnorm(0, 0.001)
    sigma ~ dunif(0, 10000)
    for(i in 1:N) {
        mu[i] <- b0 + b1 * x[i]
        y[i] ~ dnorm(mu[i], sd = sigma)
    }
})

N <- 10
constants <- list(N = N, x = 1:N)
data <- list(y = 1:N)
inits <- list(b0 = 1, b1 = 0.1, sigma = 1)
Rmodel <- nimbleModel(code, constants, data, inits, buildDerivs = TRUE)

Rmcmc <- buildHMC(Rmodel)

# Cmodel <- compileNimble(Rmodel)
# Cmcmc <- compileNimble(Rmcmc, project = Rmodel)
# samples <- runMCMC(Cmcmc)
}
\seealso{
\code{\link{addHMC}} \code{\link{configureHMC}} \code{\link{sampler_HMC}} \code{\link{configureMCMC}} \code{\link{addSampler}}
}
\author{
Daniel Turek
}
