% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dpoisppAC.R
\name{dpoisppAC}
\alias{dpoisppAC}
\alias{rpoisppAC}
\title{Poisson point process for the distribution of activity centers}
\usage{
dpoisppAC(
  x,
  lowerCoords,
  upperCoords,
  logIntensities,
  sumIntensity,
  habitatGrid,
  numGridRows,
  numGridCols,
  numPoints,
  log = 0
)

rpoisppAC(
  n,
  lowerCoords,
  upperCoords,
  logIntensities,
  sumIntensity,
  habitatGrid,
  numGridRows,
  numGridCols,
  numPoints
)
}
\arguments{
\item{x}{Matrix of x- and y-coordinates of a set of spatial points (AC locations) scaled to the habitat (\code{\link{scaleCoordsToHabitatGrid}}). Each row corresponds to a point.}

\item{lowerCoords, upperCoords}{Matrices of lower and upper x- and y-coordinates of all detection windows scaled to the habitat (see (\code{\link{scaleCoordsToHabitatGrid}}). One row for each window. Each window should be of size 1x1.}

\item{logIntensities}{Vector of log habitat intensities for all habitat windows.}

\item{sumIntensity}{Sum of the habitat intensities over all windows. Provided as an argument for computational speed, instead of calculating it in the function.}

\item{habitatGrid}{Matrix of habitat window indices. Cell values should correspond to the order of habitat windows in
\code{lowerCoords}, \code{upperCoords}, and \code{logIntensities}. 
When the habitat grid only consists of a single row or column of windows, an additional row or column of dummy indices has to be added because the \code{nimble} model code requires a matrix.}

\item{numGridRows, numGridCols}{Numbers of rows and columns of the habitat grid.}

\item{numPoints}{Number of points in the Poisson point process. This value (non-negative integer) is used to truncate \code{x} 
so that extra rows beyond \code{numPoints} are ignored.}

\item{log}{Logical argument, specifying whether to return the log-probability of the distribution.}

\item{n}{Integer specifying the number of realisations to generate. Only n = 1 is supported.}
}
\value{
\code{dpoisppAC} gives the (log) probability density of the observation matrix \code{x}. 
\code{rpoisppAC} gives coordinates of a set of randomly generated spatial points.
}
\description{
Density and random generation functions of the Poisson point process for the distribution of activity centers. 
The \code{dpoisppAC} distribution is a NIMBLE custom distribution which 
can be used to model and simulate activity center locations (\emph{x}) of multiple individual in 
continuous space over a set of habitat windows defined by their upper and lower coordinates (\emph{lowerCoords,upperCoords}). 
The distribution assumes that activity centers follow a Poisson point process with intensity = exp(logIntensities).  
All coordinates (\emph{s} and \emph{trapCoords}) should be scaled to the habitat (\code{\link{scaleCoordsToHabitatGrid}}).
}
\examples{
lowerCoords <- matrix(c(0, 0, 1, 0, 0, 1, 1, 1), nrow = 4, byrow = TRUE)
upperCoords <- matrix(c(1, 1, 2, 1, 1, 2, 2, 2), nrow = 4, byrow = TRUE)
logIntensities <- log(c(1:4))
logSumIntensity <- sum(exp(logIntensities))
habitatGrid <- matrix(c(1:4), nrow = 2, byrow = TRUE)
numGridRows <- nrow(habitatGrid)
numGridCols <- ncol(habitatGrid)
#Simulate data
x <- rpoisppAC(1, lowerCoords, upperCoords, logIntensities, logSumIntensity, habitatGrid,
               numGridRows, numGridCols, -1)
numPoints <- nrow(x)
dpoisppAC(x, lowerCoords, upperCoords, logIntensities, logSumIntensity,
          habitatGrid, numGridRows, numGridCols, numPoints, log = TRUE)
          
}
\references{
W. Zhang, J. D. Chipperfield, J. B. Illian, P. Dupont, C. Milleret, P. de Valpine and R. Bischof. 2020. 
A hierarchical point process model for spatial capture-recapture data. bioRxiv. DOI 10.1101/2020.10.06.325035
}
\author{
Wei Zhang
}
