% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/national.SMART.R
\name{national.SMART}
\alias{national.SMART}
\title{Add SMART flags to a stratified sample survey (e.g. MICS, DHS, national
SMART)}
\usage{
national.SMART(x, strata, indices = c("haz", "whz", "waz"))
}
\arguments{
\item{x}{Survey dataset (as an R data.frame) with indices present}

\item{strata}{Name of column in \code{x} that defines the strata}

\item{indices}{Names of columns in \code{x} containing indices}
}
\value{
A data.frame with same structure as \code{x} with a \code{flagSMART}
column added. This column is coded using sums of powers of two
}
\description{
Add SMART flags to a stratified sample survey (e.g. MICS, DHS, national
SMART)
}
\examples{
# Use the national.SMART() function to flag indices from a national
# SMART survey in Nigeria (flag.ex03)
svy <- flag.ex03
svyFlagged <- national.SMART(x = svy, strata = "state")

# Exclude records with flagging codes relevant to whz:
svyFlagged <- svyFlagged[!(svyFlagged$flagSMART \%in\% c(2, 3, 6, 7)), ]

}
