% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optK.R
\name{optK}
\alias{optK}
\title{Find the optimal number of bins}
\usage{
optK(X,
     Kmethod = "cluster",
     maxK = 10,
     beta = 0.2,
     lambda = 0.3,
     R = 4,
     C1 = 2.5,
     C2 = 7.8, ...)
}
\arguments{
\item{X}{Numeric vector corresponding to Y.}

\item{Kmethod}{The way to calculate the penalty in automatic binning."cluster" or "kernel".}

\item{maxK}{The maximum number of bins.}

\item{beta}{Additional parameter for automatic binning. For more detailed explanation, see reference.}

\item{lambda}{Additional parameter for automatic binning. For more detailed explanation, see reference.}

\item{R}{Additional parameter for automatic binning. For more detailed explanation, see reference.}

\item{C1}{Additional parameter for automatic binning. For more detailed explanation, see reference.}

\item{C2}{Additional parameter for automatic binning. For more detailed explanation, see reference.}

\item{...}{Arguments to be passed to methods.}
}
\value{
The optimal number of bins, the result of binning, and the summary of
        binning including the penalty values up to the maximum number of bins
        are returned.
}
\description{
This function automatically finds the optimal number of bins using dynamic programming.
}
\examples{
\donttest{
data(origdata)
optK(origdata$TIME)
}
}
\references{
Lavielle, M. and Bleakley, K.
            (2011). Automatic data binning for improved visual 
                    diagnosis of pharmacometric models. 
                    Journal of pharmacokinetics and pharmacodynamics, 38(6), 861-871.
}
