% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deparse.R
\name{.deparseDifferent}
\alias{.deparseDifferent}
\title{Identify Differences Between Standard and New Objects but used in rxUiDeparse}
\usage{
.deparseDifferent(standard, new, internal = character(0))
}
\arguments{
\item{standard}{The standard object used for comparison. (for example `foceiControl()`)}

\item{new}{The new object to be compared against the standard. This
would be what the user supplide like
`foceiControl(outerOpt="bobyqa")`}

\item{internal}{A character vector of element names to be ignored
during the comparison. Default is an empty character
vector. These are for internal items of the list that flag
certain properties like if the `rxControl()` was generated by the
`foceiControl()` procedure or not.}
}
\value{
A vector of indices indicating which elements of the
  standard object differ from the new object.
}
\description{
This function compares elements of a standard object with a new
object and identifies which elements are different.  It is used to
only show values that are different from the default when deparsing
control objects.
}
\examples{
standard <- list(a = 1, b = 2, c = 3)
new <- list(a = 1, b = 3, c = 3)
.deparseDifferent(standard, new)
}
\author{
Matthew L. Fidler
}
\keyword{internal}
