% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapper_functions.R
\name{randomforest_wrapper}
\alias{randomforest_wrapper}
\title{Wrapper for fitting a random forest using \link[randomForest]{randomForest}.}
\usage{
randomforest_wrapper(
  train,
  test,
  mtry = floor(sqrt(ncol(train$X))),
  ntree = 1000,
  nodesize = 1,
  maxnodes = NULL,
  importance = FALSE,
  ...
)
}
\arguments{
\item{train}{A list with named objects \code{Y} and \code{X} (see description).}

\item{test}{A list with named objects \code{Y} and \code{X} (see description).}

\item{mtry}{See \link[randomForest]{randomForest}.}

\item{ntree}{See \link[randomForest]{randomForest}.}

\item{nodesize}{See \link[randomForest]{randomForest}.}

\item{maxnodes}{See \link[randomForest]{randomForest}.}

\item{importance}{See \link[randomForest]{randomForest}.}

\item{...}{Other options (passed to \code{randomForest})}
}
\value{
A list with named objects (see description).
}
\description{
Compatible learner wrappers for this package should have a specific format.
Namely they should take as input a list called \code{train} that contains
named objects \code{$Y} and \code{$X}, that contain, respectively, the outcomes
and predictors in a particular training fold. Other options may be passed in
to the function as well. The function must output a list with the following
named objects: \code{test_pred} = predictions of \code{test$Y} based on the learner
fit using \code{train$X}; \code{train_pred} = prediction of \code{train$Y} based 
on the learner fit using \code{train$X}; \code{model} = the fitted model (only 
necessary if you desire to look at this model later, not used for internal 
computations); \code{train_y} = a copy of \code{train$Y}; \code{test_y} = a copy
of \code{test$Y}.
}
\details{
This particular wrapper implements the \link[randomForest]{randomForest} ensemble
methodology. We refer readers to the original package's documentation for more
details.
}
\examples{
# simulate data
# make list of training data
train_X <- data.frame(x1 = runif(50))
train_Y <- rbinom(50, 1, plogis(train_X$x1))
train <- list(Y = train_Y, X = train_X)
# make list of test data
test_X <- data.frame(x1 = runif(50))
test_Y <- rbinom(50, 1, plogis(train_X$x1))
test <- list(Y = test_Y, X = test_X)
# fit randomforest 
rf_wrap <- randomforest_wrapper(train = train, test = test)
}
