% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MED.mxModel_helper.R
\name{getMED.mxModel}
\alias{getMED.mxModel}
\title{Construct An Object of mxModel for Longitudinal Mediation Models To Be Evaluated}
\usage{
getMED.mxModel(
  dat,
  t_var,
  y_var,
  m_var,
  x_type,
  x_var,
  curveFun,
  records,
  starts,
  res_cor
)
}
\arguments{
\item{dat}{A wide-format data frame, with each row corresponding to a unique ID. It contains the observed variables
with repeated measurements and occasions for multiple longitudinal processes and a baseline predictor when applicable.
It takes the value passed from \code{getMediation()}.}

\item{t_var}{A vector of strings, with each element representing the prefix for column names related to the time
variable for the corresponding longitudinal variable at each study wave. It takes the value passed from \code{getMediation()}.}

\item{y_var}{A string specifying the prefix of the column names corresponding to the outcome variable at each study wave.
It takes the value passed from \code{getMediation()}.}

\item{m_var}{A string specifying the prefix of the column names corresponding to the mediator variable at each study wave.
It takes the value passed from \code{getMediation()}.}

\item{x_type}{A string indicating the type of predictor variable used in the model. Supported values are \code{"baseline"}
and \code{"longitudinal"}. It takes the value passed from \code{getMediation()}.}

\item{x_var}{A string specifying the baseline predictor if \code{x_type = "baseline"}, or the prefix of the column names
corresponding to the predictor variable at each study wave if \code{x_type = "longitudinal"}. It takes the value passed from
\code{getMediation()}.}

\item{curveFun}{A string specifying the functional form of the growth curve. Supported options include: \code{"linear"}
(or \code{"LIN"}), and \code{"bilinear spline"} (or \code{"BLS"}). It takes the value passed from \code{getMediation()}.}

\item{records}{A list of numeric vectors, with each vector specifying the indices of the observed study waves for
the corresponding longitudinal variable. It takes the value passed from \code{getMediation()}.}

\item{starts}{A list of initial values for the parameters, either takes the value passed from \code{getMediation()} or
derived by the helper function \code{getMED.initial()}.}

\item{res_cor}{A numeric value or vector for user-specified residual correlation between any two longitudinal processes to calculate
the corresponding initial value. It takes the value passed from \code{getMediation()}.}
}
\value{
A pre-optimized mxModel for a longitudinal mediation model.
}
\description{
This function builds up an object of mxModel for a longitudinal mediation model with user-specified functional form.
}
