% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MULTI.addpara_helper.R
\name{getMULTI.addpara}
\alias{getMULTI.addpara}
\title{Get Additional Parameters Related to Interval-specific Slopes, Interval-specific Changes and Values of Change-from-
baseline for Multivariate Latent Change Score Models}
\usage{
getMULTI.addpara(dat, t_var, y_var, curveFun, intrinsic, records, starts)
}
\arguments{
\item{dat}{A wide-format data frame, with each row corresponding to a unique ID. It contains the observed variables
with repeated measurements and occasions for multiple longitudinal outcomes. It takes the value passed from \code{getMGM()}.}

\item{t_var}{A vector of strings, with each element representing the prefix for column names related to the time
variable for the corresponding outcome variable at each study wave. It takes the value passed from \code{getMGM()}.}

\item{y_var}{A vector of strings, with each element representing the prefix for column names corresponding to a
particular outcome variable at each study wave. It takes the value passed from \code{getMGM()}.}

\item{curveFun}{A string specifying the functional form of the growth curve. Supported options for \code{y_model =
"LGCM"} include: \code{"linear"} (or \code{"LIN"}), \code{"quadratic"} (or \code{"QUAD"}), \code{"negative exponential"}
(or \code{"EXP"}), \code{"Jenss-Bayley"} (or \code{"JB"}), and \code{"bilinear spline"} (or \code{"BLS"}). Supported
options for \code{y_model = "LCSM"} include: \code{"quadratic"} (or \code{"QUAD"}), \code{"negative exponential"}
(or \code{"EXP"}), \code{"Jenss-Bayley"} (or \code{"JB"}), and \code{"nonparametric"} (or \code{"NonP"}). It takes the
value passed from \code{getMGM()}.}

\item{intrinsic}{A logical flag indicating whether to build an intrinsically nonlinear longitudinal model. It takes the
value passed from \code{getMGM()}.}

\item{records}{A list of numeric vectors, with each vector specifying the indices of the observed study waves for
the corresponding outcome variable. It takes the value passed from \code{getMGM()}.}

\item{starts}{A list of initial values for the parameters, either takes the value passed from \code{getMGM()} or derived
by the helper function \code{getMULTI.initial()}.}
}
\value{
A list containing the specification of the means and variances of interval-specific slopes, interval-specific
changes, and values of change-from-baseline for multivariate latent change score models.
}
\description{
This function derives additional parameters for multivariate latent change score models. It specifies the means and
variances of interval-specific slopes, interval-specific changes, and values of change-from-baseline.
}
\keyword{internal}
