% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSpexpf.R
\name{SSpexpf}
\alias{SSpexpf}
\alias{pexpf}
\title{self start for plateau-exponential function}
\usage{
pexpf(x, a, xs, c)

SSpexpf(x, a, xs, c)
}
\arguments{
\item{x}{input vector (x)}

\item{a}{represents the value for the plateau}

\item{xs}{represents the breakpoint at which the plateau ends}

\item{c}{represents the exponential rate}
}
\value{
a numeric vector of the same length as x containing parameter estimates for equation specified

pexpf: vector of the same length as x using the pexpf function
}
\description{
Self starter for an plateau-exponential function
}
\details{
The equation is: \eqn{for x < xs: y = a and x >= xs: a * exp(c * (x-xs))}.
}
\examples{
\donttest{
require(ggplot2)
set.seed(1234)
x <- 1:30
y <- pexpf(x, 20, 15, -0.2) + rnorm(30, 0, 1)
dat <- data.frame(x = x, y = y)
fit <- nls(y ~ SSpexpf(x, a, xs, c), data = dat)
## plot
ggplot(data = dat, aes(x = x, y = y)) + 
  geom_point() + 
  geom_line(aes(y = fitted(fit)))
}
}
