% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSquadp3xs.R
\name{SSquadp3xs}
\alias{SSquadp3xs}
\alias{quadp3xs}
\title{self start for quadratic-plateau function (xs)}
\usage{
quadp3xs(x, a, b, xs)

SSquadp3xs(x, a, b, xs)
}
\arguments{
\item{x}{input vector}

\item{a}{the intercept}

\item{b}{the slope}

\item{xs}{break-point}
}
\value{
a numeric vector of the same length as x containing parameter estimates for equation specified

quadp3xs: vector of the same length as x using the quadratic-plateau function
}
\description{
Self starter for quadratic plateau function with (three) parameters a (intercept), b (slope), xs (break-point)
}
\details{
The equation is, for a response (y) and a predictor (x): \cr
  \eqn{y ~ (x <= xs) * (a + b * x + (-0.5 * b/xs) * x^2) + (x > xs) * (a + (b^2)/(-2 * b/xs))} \cr
  
where the quadratic term is (c) is -0.5*b/xs \cr
and the asymptote is (a + (b^2)/(4 * c)).

This model does not estimate the quadratic parameter \sQuote{c} directly. 
If this is required, the model \sQuote{SSquadp3} should be used instead.
}
\examples{
\donttest{
require(ggplot2)
set.seed(123)
x <- 1:30
y <- quadp3xs(x, 5, 1.7, 20) + rnorm(30, 0, 0.6)
dat <- data.frame(x = x, y = y)
fit <- nls(y ~ SSquadp3xs(x, a, b, xs), data = dat)
## plot
ggplot(data = dat, aes(x = x, y = y)) + 
  geom_point() + 
  geom_line(aes(y = fitted(fit)))
}
}
