% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_functions.R
\name{get_functions}
\alias{get_functions}
\title{Get nonlinear functions from a separable nonlinear formula}
\usage{
get_functions(form, lp)
}
\arguments{
\item{form}{Either a string in the form \code{'y ~ ...'} or an object of \code{formula} class}

\item{lp}{A string array with the names of the linear parameters contained in the formula as obtained with \code{get_parameters} function}
}
\value{
An array containing the strings for the  nonlinear functions of the formula.
}
\description{
Returns the nonlinear functions of a \code{formula} as charater strings.
}
\details{
This is an internal function used by \code{nls_tac}. A separable nonlinear formula is of the form
\deqn{y ~ a_1 f_1(x;p) + a_2 f_2(x;p) + \ldots + a_n f_n(x;p),}
where \eqn{f_1},..., \eqn{f_n} are general nonlinear functions, \eqn{a_1},...,\eqn{a_n}, are the linear coefficients and \eqn{p} is the vector of nonlinear parameters.
The \code{formula} given in the input should be of this form and \code{get_functions} will return an array with the string expressions of functions \eqn{f_i}.
}
\note{
Also formulas of the form
\deqn{y ~ a_1/f_1(x;p) + a_2/f_2(x;p) + \ldots}
could be given.
}
\author{
\strong{Mariano Rodríguez-Arias} (\email{arias@unex.es}).
\emph{Deptartment of Mathematics}

\strong{Juan Antonio Fernández Torvisco} (\email{jfernandck@alumnos.unex.es}).
\emph{Department of Mathematics}

University of Extremadura (Spain)

\strong{Rafael Benítez} (\email{rafael.suarez@uv.es}).
\emph{Department of Business Mathematics}

University of Valencia (Spain)
}
