% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.nnGarrote.R
\name{predict.nnGarrote}
\alias{predict.nnGarrote}
\title{Predictions for nnGarrote Object}
\usage{
\method{predict}{nnGarrote}(object, newx, ...)
}
\arguments{
\item{object}{An object of class nnGarrote}

\item{newx}{A matrix with the new data.}

\item{...}{Additional arguments for compatibility.}
}
\value{
A matrix with the predictions of the \code{nnGarrote} object.
}
\description{
\code{predict.nnGarrote} returns the prediction for nnGarrote for new data.
}
\examples{
\donttest{
# Setting the parameters
p <- 500
n <- 100
n.test <- 5000
sparsity <- 0.15
rho <- 0.5
SNR <- 3
set.seed(0)
# Generating the coefficient
p.active <- floor(p*sparsity)
a <- 4*log(n)/sqrt(n)
neg.prob <- 0.2
nonzero.betas <- (-1)^(rbinom(p.active, 1, neg.prob))*(a + abs(rnorm(p.active)))
true.beta <- c(nonzero.betas, rep(0, p-p.active))
# Two groups correlation structure
Sigma.rho <- matrix(0, p, p)
Sigma.rho[1:p.active, 1:p.active] <- rho
diag(Sigma.rho) <- 1
sigma.epsilon <- as.numeric(sqrt((t(true.beta) \%*\% Sigma.rho \%*\% true.beta)/SNR))

# Simulate some data
library(mvnfast)
x.train <- mvnfast::rmvn(n, mu=rep(0,p), sigma=Sigma.rho)
y.train <- 1 + x.train \%*\% true.beta + rnorm(n=n, mean=0, sd=sigma.epsilon)
x.test <- mvnfast::rmvn(n.test, mu=rep(0,p), sigma=Sigma.rho)
y.test <- 1 + x.test \%*\% true.beta + rnorm(n.test, sd=sigma.epsilon)

# Applying the NNG with Ridge as an initial estimator
nng.out <- nnGarrote(x.train, y.train, intercept=TRUE,
                     initial.model=c("LS", "glmnet")[2],
                     lambda.nng=NULL, lambda.initial=NULL, alpha=0)
nng.predictions <- predict(nng.out, newx=x.test)
mean((nng.predictions-y.test)^2)/sigma.epsilon^2
coef(nng.out)
}

}
\seealso{
\code{\link{nnGarrote}}
}
\author{
Anthony-Alexander Christidis, \email{anthony.christidis@stat.ubc.ca}
}
