% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net.thief.R
\name{elm.thief}
\alias{elm.thief}
\title{ELM network for THieF.}
\usage{
elm.thief(y, h = NULL, ...)
}
\arguments{
\item{y}{Input time series. Can be ts or msts object.}

\item{h}{Forecast horizon. If NULL then h is set to match frequency of time series.}

\item{...}{Additional arguments passed to \code{\link{elm}}.}
}
\value{
An object of classes "\code{forecast.net}" and "\code{forecast}".
  The function \code{plot} produces a plot of the forecasts.
  An object of class \code{"forecast.net"} is a list containing the following elements:
\itemize{
\item{\code{method}{ - The name of the forecasting method as a character string}}
\item{\code{mean}{ - Point forecasts as a time series}}
\item{\code{all.mean}{ - An array h x reps of all ensemble members forecasts, where reps are the number of ensemble members.}}
\item{\code{x}{ - The original time series (either \code{fit} used to create the network.}}
\item{\code{fitted}{ - Fitted values. Any values not fitted for the initial period of the time series are imputted with NA.}}
\item{\code{residuals}{ - Residuals from the fitted network.}}
}
}
\description{
Function for ELM forecasting with Temporal Hierarchies.
}
\note{
This function is created to work with Temporal Hierarchied (\href{https://cran.r-project.org/package=thief}{thief} package). For conventional ELM networks use \code{\link{elm}}.
}
\examples{
\dontrun{
  library(thief)
  frc <- thief(AirPassengers,forecastfunction=elm.thief)
  plot(frc)
}

}
\references{
\itemize{
  \item{For forecasting with temporal hierarchies see: Athanasopoulos G., Hyndman R.J., Kourentzes N., Petropoulos F. (2017) \href{https://kourentzes.com/forecasting/2017/02/27/forecasting-with-temporal-hierarchies-3/}{Forecasting with Temporal Hierarchies}. \emph{European Journal of Operational research}, \bold{262}(\bold{1}), 60-74.}
  \item{For combination operators see: Kourentzes N., Barrow B.K., Crone S.F. (2014) \href{https://kourentzes.com/forecasting/2014/04/19/neural-network-ensemble-operators-for-time-series-forecasting/}{Neural network ensemble operators for time series forecasting}. \emph{Expert Systems with Applications}, \bold{41}(\bold{9}), 4235-4244.}
}
}
\seealso{
\code{\link{elm}}, \code{\link{mlp.thief}}.
}
\author{
Nikolaos Kourentzes, \email{nikolaos@kourentzes.com}
}
\keyword{elm}
\keyword{thief}
\keyword{ts}
