% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.r
\name{covNrow2col}
\alias{covNrow2col}
\title{Conversion of the Covariance Matrix of the Row-wise Vectorized Cell Counts to Column-wise
Vectorized Cell Counts in an NNCT}
\usage{
covNrow2col(covN)
}
\arguments{
\item{covN}{The \eqn{k^2 \times k^2} covariance matrix of row-wise vectorized cell counts of NNCT, \code{ct}.}
}
\value{
The \eqn{k^2 \times k^2} covariance matrix of column-wise vectorized cell counts \eqn{N_{ij}} for 
\eqn{i,j=1,\ldots,k} in the NNCT, \code{ct}.
}
\description{
Converts the \eqn{k^2 \times k^2} covariance matrix of row-wise vectorized cell counts \eqn{N_{ij}} for \eqn{i,j=1,\ldots,k} 
in the NNCT, \code{ct} to the covariance matrix of column-wise vectorized cell counts.
In the output, the covariance matrix entries are \eqn{cov(N_{ij},N_{kl})} when \eqn{N_{ij}} values are
corresponding to the column-wise vectorization of \code{ct}.
These covariances are valid under RL or conditional on \eqn{Q} and \eqn{R} under CSR.

See also 
(\insertCite{dixon:1994,dixon:NNCTEco2002,ceyhan:eest-2010,ceyhan:jkss-posthoc-2017;textual}{nnspat}).
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:2,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)

W<-Wmat(ipd)
Qv<-Qvec(W)$q
Rv<-Rval(W)
varN<-var.nnct(ct,Qv,Rv)

covNrow<-cov.nnct(ct,varN,Qv,Rv)
covNcol1<-cov.nnct(ct,varN,Qv,Rv,byrow=FALSE)
covNcol2<-covNrow2col(covNrow)

covNrow
covNcol1
covNcol2

all.equal(covNcol1,covNcol2)

#############
n<-40
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:4,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)

W<-Wmat(ipd)
Qv<-Qvec(W)$q
Rv<-Rval(W)
varN<-var.nnct(ct,Qv,Rv)

covNrow<-cov.nnct(ct,varN,Qv,Rv)
covNcol1<-cov.nnct(ct,varN,Qv,Rv,byrow=FALSE)
covNcol2<-covNrow2col(covNrow)

covNrow
covNcol1
covNcol2

all.equal(covNcol1,covNcol2)

#1D data points
n<-20  #or try sample(1:20,1)
X<-as.matrix(runif(n))# need to be entered as a matrix with one column
#(i.e., a column vector), hence X<-runif(n) would not work
ipd<-ipd.mat(X)
cls<-sample(1:2,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)

W<-Wmat(ipd)
Qv<-Qvec(W)$q
Rv<-Rval(W)
varN<-var.nnct(ct,Qv,Rv)
Qv<-Qvec(W)$q
Rv<-Rval(W)
varN<-var.nnct(ct,Qv,Rv)
cov.nnct(ct,varN,Qv,Rv)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{cov.nnct}}
}
\author{
Elvan Ceyhan
}
