% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.r
\name{runif.circ}
\alias{runif.circ}
\title{Generation of Uniform Points in a Circle}
\usage{
runif.circ(n, cent = c(0, 0), rad = 1)
}
\arguments{
\item{n}{A positive integer representing the number of points to be generated uniformly in the circle}

\item{cent}{A 2D point representing the center of the circle, with default=\code{c(0,0)}}

\item{rad}{A positive real number representing the radius of the circle.}
}
\value{
A \code{list} with the elements
\item{pat.type}{\code{"1c"} for the 1-class pattern of the uniform data in the circle}
\item{type}{The type of the point pattern}
\item{parameters}{center of the circle, \code{cent}, and the radius of the circle, \code{rad}}
\item{lab}{The class labels of the generated points, \code{NULL} for this function, since points belong to the same 
class}
\item{init.cases}{The initial points, \code{NULL} for this function}
\item{gen.points}{The output set of generated points uniform in the circle.}
\item{ref.points}{The input set of reference points, it is \code{NULL} for this function.}
\item{desc.pat}{Description of the point pattern}
\item{mtitle}{The \code{"main"} title for the plot of the point pattern}
\item{num.points}{The number of generated points.}
\item{xlimit,ylimit}{The possible ranges of the \eqn{x}- and \eqn{y}-coordinates of the generated points}
}
\description{
An object of class \code{"Patterns"}.

Generates \code{n} 2D points uniformly in the circle with center=\code{cent} and radius=\code{rad} using the rejection 
sampling approach (i.e., the function generates points in the smallest square containing the circle, keeping
only the points inside the circle until \eqn{n} points are generated).
The defaults for \code{cent=c(0,0)} and \code{rad=1}.
}
\examples{
n<-20  #or try sample(1:20,1);  #try also 10, 100, or 1000;
r<-.1; #try also r<-.3 or .5
cent<-c(1,2)

#data generation
Xdat<-runif.circ(n,cent,r) #generated data
Xdat

summary(Xdat)
plot(Xdat,asp=1)
plot(Xdat)

}
\seealso{
\code{\link[stats]{runif}}
}
\author{
Elvan Ceyhan
}
