% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nntrf.R
\name{nntrf}
\alias{nntrf}
\title{{nntrf: a supervised transformation function based on neural networks (Neural Net based Transformations)}}
\usage{
nntrf(keep_nn = TRUE, repetitions = 1, random_seed = NULL, ...)
}
\arguments{
\item{keep_nn}{(default TRUE) Keep NN model. In most cases, the actual NN and associated results obtained by nnet is not required}

\item{repetitions}{(default 1) Repeat nnet several times with different random seeds and select the best run using nnet's minimum \emph{value}. This is useful because some random initialization of weights may lead to local minima.}

\item{random_seed}{(default NULL)}

\item{...}{See \code{\link{nnet}} params. Most important: \itemize{
\item x \strong{matrix} of x values for examples. Important: it must be a matrix of real numbers (not a data.frame). The transformation requires matrix multiplication, hence it cannot contain factors or strings.
\item y vector or matrix of target values for examples. Use factors for classification problems.
\item size number of units in the hidden layer.  
\item maxit steps is the number of iterations of the net.
}}
}
\value{
list of: \itemize{
  \item trf: a function that transforms the input dataset using the weights of the hidden layer. This function has three arguments:
    \itemize{
      \item x: the input \strong{matrix} to be transformed
      \item use_sigmoid (default TRUE): Whether the sigmoid function should be used for the transformation. nnet uses the sigmoid in the output layer, but in some cases better results could be obtained with use_sigmoid=FALSE.
      \item norm (default FALSE): If TRUE, this function's output is normalized (scaled) to range 0-1
    }
  \item mod: values returned by nnet 
  \item matrix1: weights of hidden layer 
  \item matrix2: weights of output layer 
  }
}
\description{
{This function transforms a dataset into the activations of the neurons of the hidden layer of a neural network. 
This is done by training a neural network and then computing the activations of the neural network for each input pattern
}
}
\examples{
data("doughnutRandRotated")
rd <- doughnutRandRotated
n <- nrow(rd)
set.seed(1)
training_index <- sample(1:n, round(0.6*n))
train <- rd[training_index,]
test <- rd[-training_index,]
x_train <- train[,-ncol(train)]
y_train <- train[,ncol(train)]
x_test <- test[,-ncol(test)]
y_test <- test[,ncol(test)]
set.seed(1)
# Change maxit to 100 for reasonable results
nnpo <- nntrf(formula=V11~.,
              data=train,
              size=4, maxit=50, trace=TRUE)
trf_x_train <- nnpo$trf(x=x_train, use_sigmoid=FALSE)
trf_x_test <- nnpo$trf(x=x_test, use_sigmoid=FALSE)               
outputs <- FNN::knn(trf_x_train, trf_x_test, factor(y_train))
success <- mean(outputs == y_test)
print(success)
}
\seealso{
\code{\link{nnet}}
}

