% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{create_storm_data}
\alias{create_storm_data}
\title{Get storm data based on date range or storm name}
\usage{
create_storm_data(date_range = NULL, storm = NULL,
  file_type = "details")
}
\arguments{
\item{date_range}{A character vector of length two with the start and end
dates to pull data for (e.g., \code{c("1999-10-16", "1999-10-18")}).}

\item{storm}{A character string with the name of the storm to pull storm
events data for. This string must follow the format
"[storm-name]-[4-digit storm year]" (e.g., \code{"Floyd-1999"}).
Currently, this functionality only works for storms included in the
extended hurricane best tracks, which covers 1988 to 2015.}

\item{file_type}{A character string specifying the type of file you would
like to pull. Choices include: "details" (the default), "fatalities", or
"locations".}
}
\description{
This function pulls storm events data based on a specified date range and /
or storm name. (Note: This function pulls full years' worth of data. Later
functions filter down to the exact date range desired.)
}
\examples{
\dontrun{
floyd_data <- create_storm_data(date_range = c("1999-10-16", "1999-10-18"))
floyd_data2 <- create_storm_data(storm = "Floyd-1999")
}

}
