% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Result.R
\docType{methods}
\name{dbClearResult}
\alias{dbClearResult}
\alias{dbClearResult,AthenaResult-method}
\title{Clear Results}
\usage{
\S4method{dbClearResult}{AthenaResult}(res, ...)
}
\arguments{
\item{res}{An object inheriting from \linkS4class{DBIResult}.}

\item{...}{Other arguments passed on to methods.}
}
\value{
\code{dbClearResult()} returns \code{TRUE}, invisibly.
}
\description{
Frees all resources (local and Athena) associated with result set. It does this by removing query output in AWS S3 Bucket,
stopping query execution if still running and removed the connection resource locally.
}
\note{
If a user does not have permission to remove AWS S3 resource from AWS Athena output location, then an AWS warning will be returned.
      For example \code{AccessDenied (HTTP 403). Access Denied}.
      It is better use query caching or optionally prevent clear AWS S3 resource using \code{\link{noctua_options}}
      so that the warning doesn't repeatedly show.
}
\examples{
\dontrun{
# Note: 
# - Require AWS Account to run below example.
# - Different connection methods can be used please see `noctua::dbConnect` documnentation

library(DBI)

# Demo connection to Athena using profile name 
con <- dbConnect(noctua::athena())

res <- dbSendQuery(con, "show databases")
dbClearResult(res)

# Check if connection if valid after closing connection
dbDisconnect(con)
}
}
\seealso{
\code{\link[DBI]{dbIsValid}}
}
